# # Copyright 2003-2005 Six Apart. This code cannot be redistributed without
# permission from www.sixapart.com.
#
# $Id:$

package MT::L10N::ja;
use strict;
use MT::L10N;
use MT::L10N::en_us;
use vars qw( @ISA %Lexicon );
@ISA = qw( MT::L10N::en_us );

## The following is the translation table.

%Lexicon = (

	'_ERROR_CGI_PATH' => 'CGIPathの設定に誤りがあるか、環境設定ファイル (mt-config.cgi) 内に見つかりません。ヘルプに従って設定してください。',
	'_ERROR_CONFIG_FILE' => '環境設定ファイル (mt-config.cgi) が見つかりません。ヘルプに従って設定してください。',
	'_ERROR_DATABASE_CONNECTION' => 'データベース接続の設定に誤りがあるか、環境設定ファイル (mt-config.cgi) 内に見つかりません。ヘルプに従って設定してください。',
	'_NOTIFY_REQUIRE_CONFIRMATION' => '確認のメールを[_1]あてに送りました。登録するためには、メールに書かれているURLにアクセスしてください。このメールアドレスがあなたのものかを確認します。',
	'_POWERED_BY' => 'Powered by<br /><a href="http://www.sixapart.jp/movabletype/">Movable Type <$MTVersion$></a>',
	'_SYSTEM_TEMPLATE_COMMENT_ERROR' => 'コメントの投稿で、エラーが発生したときに表示します。',
	'_SYSTEM_TEMPLATE_COMMENT_PENDING' => '投稿したコメントが、保留されたり、迷惑コメントと判断されたときに表示します。',
	'_SYSTEM_TEMPLATE_COMMENT_PREVIEW' => 'コメントの投稿で、内容を確認したいときに表示します。',
	'_SYSTEM_TEMPLATE_COMMENTS' => 'コメントの投稿で、ポップアップ・ウィンドウを使うように設定したときの表示レイアウトです。',
	'_SYSTEM_TEMPLATE_DYNAMIC_ERROR' => 'ダイナミック・ページの出力で、エラーが発生したときに表示します。',
	'_SYSTEM_TEMPLATE_PINGS' => '特定のエントリーに送られたトラックバックの一覧を表示するときのレイアウトです。',
	'_SYSTEM_TEMPLATE_POPUP_IMAGE' => '画像をポップアップ・ウィンドウで表示するときのレイアウトです。',
	'_THROTTLED_COMMENT' => '不必要なコメントの投稿を防ぐために、連続した投稿を受け付けないように設定しています。しばらくしてから、もう一度試してみてください。',
	'_THROTTLED_COMMENT_EMAIL' => 'ブログ「[_1]」へのコメントが指定された[_2]秒間に複数回行われたため、自動的にそのIPアドレスを禁止IPアドレスリストに追加しました。[_3]がその IPアドレスです。必要であれば、このIPアドレス[_4]を一覧から取り除いてください。',
	'_USAGE_ARCHIVING_1' => 'アーカイブする頻度、種別を選択してください。選択したアーカイブごとに複数のアーカイブ・テンプレートを選択することが出来ます。例えば、月別のアーカイブに2種類のビューを用意し、1つめは個別のエントリーをすべて含むビュー、2つめはカレンダーを表示するビューとすることができます。',
	'_USAGE_ARCHIVING_2' => '1つ以上のテンプレートとアーカイブの種類を関連づけた場合、それぞれのアーカイブ・ファイルとテンプレートのセットの出力先を設定できます。',
	'_USAGE_ARCHIVING_3' => '新しくアーカイブ・テンプレートを関連づけたい種類を選択してください。その次に、関連づけたいテンプレートを選択してください。',
	'_USAGE_AUTHORS' => '現在登録された投稿者の一覧です。名前をクリックすると、それぞれの投稿者の権限を編集できます。チェックボックスにチェックしてから「削除」ボタンをクリックすると、投稿者を削除できます。特定のブログに関する権限をはずす場合は、投稿者の権限を編集して、権限をすべて外してください。「削除」ボタンを使うと、投稿者をシステムから削除します。',
	'_USAGE_BANLIST' => 'このサイトへのコメント、トラックバックが禁止されているIPアドレスの一覧です。このリストに新しくIPアドレスを追加する場合は、以下のフォームにIPアドレスを入力してください。IPアドレスをリストから削除する場合は、選択した後に「削除」ボタンを押してください',
	'_USAGE_BOOKMARKLET_1' => 'エントリーを、1クリックするだけで投稿し公開できる「クイック投稿」を設定できます。',
	'_USAGE_BOOKMARKLET_2' => 'クイック投稿のレイアウトをカスタマイズできます。例えば、クイック投稿でも概要を追加できます。クイック投稿の標準設定では、投稿するブログを選択するプルダウンメニュー、投稿の状態 (下書きか公開) を選択するプルダウンメニュー、タイトル、エントリーの内容が設定されています。',
	'_USAGE_BOOKMARKLET_3' => '「クイック投稿」をインストールするため、このリンクを、ブラウザのリンクかお気に入りに追加してください : ',
	'_USAGE_BOOKMARKLET_4' => '「クイック投稿」をインストールした後は、ウェブを見ているときはいつでも 投稿できます。投稿したいページを見ているときに「クイック投稿」をクリックすると、編集ウィンドウが開きます。ウィンドウでブログを選んで投稿を押すだけで、エントリーを作成できます。',
	'_USAGE_BOOKMARKLET_5' => '他にも、Windowsでインターネットエクスプローラーを使っているなら、「クイック投稿」をコンテキスト・メニューに追加できます。下のリンクをクリックし、Windowsレジストリの登録エントリーを保存してください。保存したファイルをダブルクリックしてWindowsレジストリに登録します。その後、ブラウザを再起動すると、右クリックで使えます。',
	'_USAGE_CATEGORIES' => 'エントリーをわかりやすく整理したり、アーカイブやブログの画面で見やすくできます。エントリーの投稿時だけでなく、編集時でも、カテゴリーを指定できます。サブカテゴリーの作成は、該当するカテゴリーで「作成」をクリックします。また、「移動」をクリックすると、カテゴリーを移動できます。',
	'_USAGE_COMMENT' => '選択したコメントを編集してください。編集後、「保存」ボタンを押してください。編集内容を反映させるためには、再構成を行ってください。',
	'_USAGE_COMMENTERS_LIST' => '認証サービスで認証されたコメント投稿者の一覧です。コメント投稿者を登録する、コメントの投稿を禁止する、より詳しい情報を表示することができます。',
	'_USAGE_COMMENTS_LIST_1' => '「[_1]」のコメントの一覧です。コメントの編集や削除ができます。タイトルをクリックすると、指定したコメントを編集できます。',
	'_USAGE_COMMENTS_LIST_2' => 'すべてのブログのコメントの一覧です。コメントの編集や削除ができます。タイトルをクリックすると、指定したコメントを編集できます。',
	'_USAGE_ENTRYPREFS' => 'エントリーの編集画面に表示されるフィールドの設定ができます。標準的な設定(基本か拡張)、もしくは自分で必要なフィールドを設定できるカスタム を選択してください。',
	'_USAGE_EXPORT_1' => 'エントリーの簡単なバックアップ方法が、「エントリーの書き出し」です。書き出したデータを、復旧のために使うこともできます。',
	'_USAGE_EXPORT_2' => 'エントリーを書き出すには、下のリンク ("Export Entries From [_1]") をクリックしてください。書き出したデータをファイルに保存するためには、Mac の場合は <code>option</code> キー、WIndwos の場合は <code>Shift<//code> を押しながら、リンクをクリックしてください。表示されたデータをコピー、ペーストしてもいいです。(<a href="#" onclick="openManual(\'importing\', \'export_ie\')">Internet Explorer を使っての書き出しについて</a>)',
	'_USAGE_EXPORT_3' => 'このリンクをクリックすると、Tangentサーバーにこのブログのエントリーをすべて書き出せます。Movable TypeにTangent Add-onをインストールしていれば、一回押すだけでエントリーを移すことができ、必要なときにいつでも実行可能です。',
	'_USAGE_FEEDBACK_PREFS' => 'この画面では、コメントやトラックバックの投稿について設定できます。',
	'_USAGE_FORGOT_PASSWORD_1' => 'パスワードを再設定します。パスワードはシステム側で変更され、新しいパスワードはこちらになります:',
	'_USAGE_FORGOT_PASSWORD_2' => '新しいパスワードを使ってMovable Typeにログインし、すぐにパスワードを変更してください。',
	'_USAGE_IMPORT' => 'Movable Type、または他のブログ・システム (Bloggerなど) からエントリーを読み込んで、登録できます。以下のフォームで条件を指定してください。読み込むファイルを、環境設定ファイル (mt-config.cgi) で指定した場所に保存してください。',
	'_USAGE_LIST_1' => '「[_1]」のエントリーの一覧です。エントリーの編集や削除ができます。タイトルをクリックすると、指定したエントリーを編集できます。',
	'_USAGE_LIST_2' => 'すべてのブログのエントリーの一覧です。エントリーの編集や削除ができます。タイトルをクリックすると、指定したエントリーを編集できます。',
	'_USAGE_LIST_POWER' => '「[_1]」のエントリーの一括編集画面です。下のフォームを使うと、画面に表示されているどのエントリーの設定でも変更できます。変更が終わったら、保存を押してください。通常のエントリー編集画面と同様に、フィルタや一画面に表示されるエントリー数を設定することもできます。',
	'_USAGE_NEW_AUTHOR' => 'この画面では、新規に投稿者を作成し、個々のブログへのアクセス権限を設定できます。<strong>アスタリスク (*) がついている箇所は、必ず入力してください。</strong>',
	'_USAGE_NOTIFICATIONS' => 'エントリーが投稿された際に、電子メールによるお知らせ (通知) するメンバーの一覧です。メンバーを新しく追加する場合は、フォームにアドレスを入力してください。URLはオプションです。ユーザーを削除する場合は、チェックボックスをクリックして、「削除」ボタンを押してください。',
	'_USAGE_PERMISSIONS_1' => '[_1]の権限を変更します。編集権限のあるブログの一覧内のブログについて「[_1]」にアクセス権限を与えたいボックスにチェックを入れてください。',
	'_USAGE_PERMISSIONS_2' => '他の投稿者の権限を編集するには、プルダウンメニューで投稿者を選んで、編集を押してください。',
	'_USAGE_PERMISSIONS_3' => '投稿者を編集して、アクセス権限を追加/削除するには、二つの方法があります。簡単に編集するには、ユーザーをメニューから選んで編集を押します。もう一つは、投稿者全員の一覧から選んで、編集、または削除する方法です。',
	'_USAGE_PERMISSIONS_4' => '各ブログに、複数の投稿者を指定できます。新しい投稿者を追加する場合は、新規に投稿者を登録します。次に、対象のブログに対する権限を投稿者に設定します。投稿者の権限を編集は、いつでもできます。',
	'_USAGE_PING_LIST_1' => '「[_1]」のトラックバックの一覧です。トラックバックの編集や削除ができます。概要をクリックすると、指定したトラックバッを編集できます。',
	'_USAGE_PING_LIST_2' => 'すべてのブログのトラックバックの一覧です。トラックバックの編集や削除ができます。概要をクリックすると、指定したトラックバックを編集できます。',
	'_USAGE_PLACEMENTS' => 'エントリーにサブカテゴリーを設定できます。一覧の左側は、エントリーにメイン/サブどちらとも設定されていないカテゴリー、右側はサブカテゴリーとして設定されているカテゴリーです。',
	'_USAGE_PLUGINS' => 'インストールしているプラグインの一覧です。',
	'_USAGE_PREFS' => 'この画面では、ウェブログのアーカイブ、コメント、トラックバックと通知について設定できます。新しいウェブログを作ったときには、初期値の設定になります。',
	'_USAGE_PROFILE' => 'プロフィールを編集します。ログイン名、パスワードが編集されたときには、ログイン権限は自動的に更新されます。変更後、再度ログインする必要はありません。',
	'_USAGE_REBUILD' => '修正内容をウェブサイトに反映するために、<a href="#" onclick="doRebuild()">再構築</a>してください。.',
	'_USAGE_SEARCH' => 'エントリー内の文字列を検索したり、文字列を置き換えができます。<p><strong>重要</strong>: 置換するときは注意して使ってください。なぜなら、<strong>元に戻すことができない</strong>からです。不安な場合は、置き換える前に、エントリーの書き出し機能を使ってバックアップしてください。</p>',
	'_USAGE_UPLOAD' => 'サーバーのサイト・パス、もしくはアーカイブ・パスに指定されたディレクトリーに、ファイルをアップロードできます。下のフォームに書き足せば、それぞれのディレクトリーの下に置くこともできます (例えば <i>images</i> ) 。もし、そのディレクトリーがなかったら、自動的に作られます。',
	'_USAGE_VIEW_LOG' => 'エラーの場合は、<a href="[_1]">ログ</a>をチェックしてください。',
	'Atom Index' => 'Atom',
	'Category' => 'カテゴリー',
	'Category Archive' => 'カテゴリー・アーカイブ',
	'CATEGORY_ADV' => 'カテゴリー',
	'Daily' => '日別',
	'DAILY_ADV' => '日別',
	'Date-Based Archive' => '日付アーカイブ',
	'Dynamic Site Bootstrapper' => 'Dynamic Site Bootstrapper',
	'Individual' => 'エントリー',
	'Individual Entry Archive' => 'エントリー・アーカイブ',
	'INDIVIDUAL_ADV' => 'エントリー',
	'Main Index' => 'メインページ',
	'Master Archive Index' => 'アーカイブページ',
	'Monthly' => '月別',
	'MONTHLY_ADV' => '月別',
	'RSD' => 'RSD',
	'RSS 1.0 Index' => 'RSS 1.0',
	'RSS 2.0 Index' => 'RSS 2.0',
	'Stylesheet' => 'スタイルシート',
	'Weekly' => '週別',
	'WEEKLY_ADV' => '週別',
	'&lt;&lt; Remove' => '&lt;&lt; 削除',
	'&lt;MT[_1]> with no &lt;/MT[_1]>' => '<MT[_1]>タグが閉じられていません。',
	'([_1])' => '([_1])',
	'(author deleted)' => '(削除されました)',
	'(Banned)' => '(禁止)',
	'(Disable all outbound TrackBacks.)' => '(トラックバックの送信はできません)',
	'(Help?)' => '(ヘルプ?)',
	'(If you haven\'t left a comment here before, you may need to be approved by the site owner before your comment will appear. Until then, it won\'t appear on the entry. Thanks for waiting.)' => '(いままで、ここでコメントしたことがないときは、コメントを表示する前にこのブログのオーナーの承認が必要になることがあります。承認されるまではコメントは表示されません。そのときはしばらく待ってください。)',
	'(no reason given)' => '(原因は不明)',
	'(Optional)' => '(オプション)',
	'(Probably) Running under cgiwrap or suexec' => '(おそらく)cgiwrapもしくはsuexecが利用できます。',
	'(Separate URLs with a carriage return.)' => '(複数のURLを入力する場合は、改行してください。)',
	'(Trusted)' => '(登録済み)',
	'(untitled)' => '(タイトルなし)',
	'(you may use HTML tags for style)' => '(スタイル用のHTMLタグが使えます)',
	', and it has been posted to your site' => 'ならびに公開しました。',
	'.' => '',
	'. Now you can comment.' => 'さん。コメントができます。',
	'. Now you can comment. ' => 'さん。コメントしてください。',
	': Archives' => ': アーカイブ',
	': Discussion on [_1]' => ': トラックバックの一覧 - [_1]',
	'[_1] can be used only if you have enabled Category archives.' => '「[_1]」はカテゴリー・アーカイブで利用できます。',
	'[_1] can be used only with Daily, Weekly, or Monthly archives.' => '「[_1]」は日別、週別、月別いずれかのアーカイブで利用できます。',
	'[_1] died with: [_2]' => '「[_1]」は、次の理由で使えません: [_2]',
	'[_1] has been successfully added to [_2].' => '[_1]をブログ「[_2]」の投稿者として追加しました。',
	'[_1] result(s) found.' => '[_1]件見つかりました。',
	'[_1] returned error: [_2]' => '「[_1]」でエラーが発生しました: [_2]',
	'[_1] Settings' => '設定: [_1]',
	'[_1] Update: [_2]' => '[_1]更新: [_2]',
	'[quant,_1,day] ago' => '[quant,_1,日,日]前',
	'[quant,_1,day] from now' => '[quant,_1,日,日]後',
	'[quant,_1,day], [quant,_2,hour] ago' => '[quant,_1,日,日][quant,_2,時間,時間]前',
	'[quant,_1,day], [quant,_2,hour] from now' => '[quant,_1,日,日][quant,_2,時間,時間]後',
	'[quant,_1,entry,entries]' => '[quant,_1,件,件]',
	'[quant,_1,hour] ago' => '[quant,_1,時間,時間]前',
	'[quant,_1,hour] from now' => '[quant,_1,時間,時間]後',
	'[quant,_1,hour], [quant,_2,minute] ago' => '[quant,_1,時間,時間][quant,_2,分,分]前',
	'[quant,_1,hour], [quant,_2,minute] from now' => '[quant,_1,時間,時間][quant,_2,分,分]後',
	'[quant,_1,minute] ago' => '[quant,_1,分,分]前',
	'[quant,_1,minute] from now' => '[quant,_1,分,分]後',
	'[quant,_1,row]' => '[quant,_1,行,行]',
	'[quant,_1,TrackBack]' => '[quant,_1,件,件]',
	'<$MTCategoryTrackbackLink$> must be used in the context of a category, or with the \'category\' attribute to the tag.' => '<$MTCategoryTrackbackLink$>タグは、<MTCategories>コンテナ内、もしくはカテゴリー属性を指定したタグで利用できます。',
	'\'[_1]\' added entry #[_2]' => '[_1]が投稿しました (エントリーID: [_2])',
	'4th argument to add_callback must be a CODE reference.' => 'add_callback関数の4番目の引数は、CODEである必要があります。',
	'4th argument to add_callback must be a perl CODE reference' => 'add_callback関数の4番目の引数は、CODEである必要があります。',
	'A file named \'[_1]\' already exists. Do you want to overwrite this file?' => 'ファイル[_1]がすでに同フォルダー内に存在しています。上書きしてもいいですか?。',
	'A new comment has been posted on your blog [_1], on entry #[_2] ([_3]).' => '「[_3] (ブログ: [_1]、エントリーID: [_2])」への新しいコメントを受け付けました。',
	'A new TrackBack has been posted on your blog [_1], on category #[_2] ([_3]).' => '「[_3] (ブログ: [_1]、カテゴリーID: [_2])」への新しいトラックバックを受け付けました。',
	'A new TrackBack has been posted on your blog [_1], on entry #[_2] ([_3]).' => '「[_3] (ブログ: [_1]、エントリーID: [_2])」への新しいトラックバックを受け付けました。',
	'A new version of Movable Type has been installed.  We\'ll need to complete a few tasks to update your database.' => 'Movable Typeの最新版のインストールが終了しました。次にデータベースのアップグレードを行います。少々お待ちください。',
	'Above' => '上',
	'Accept Comments' => 'コメントを受信',
	'Accept comments from' => '投稿を受け付ける条件',
	'Accept inbound TrackBacks?' => 'トラックバックを受け付ける場合は設定します。',
	'Accept TrackBacks' => 'トラックバックを受信',
	'Accept TrackBacks:' => 'トラックバックを受信: ',
	'Action: Junked (score below threshold)' => '迷惑コメント/トラックバックと判断しました。',
	'Action: Published (default action)' => '公開しました。',
	'Actions' => '操作',
	'Actions:' => 'ボタン位置: ',
	'Active Authors' => 'アクティブな投稿者',
	'Activity Log' => 'ログ',
	'Add' => '追加',
	'Add A Category' => 'カテゴリーを追加する',
	'Add a Category' => 'カテゴリーを追加する',
	'Add new category...' => '新しいカテゴリーを追加する',
	'Add QuickPost to Windows right-click menu' => '「クイック投稿」をインターネット・エクスプローラー (Windows) のコンテキスト・メニューに追加する',
	'Add Recipient' => '通知先を登録',
	'Add user to an additional weblog:' => '投稿者を別のブログに登録する: ',
	'Advanced' => '拡張',
	'Advanced Archive Publishing:' => 'アーカイブの設定: ',
	'Aggregate' => '一括管理',
	'all' => 'すべての',
	'All data imported successfully! Make sure that you remove the files that you imported from the \'import\' folder, so that if/when you run the import process again, those files will not be re-imported.' => 'データがすべて読み込まれました。今回読み込んだファイルは、次回の読み込み時に再び読み込まれないよう、読み込み元ディレクトリーから削除してください。',
	'All of your files have been rebuilt.' => 'すべて再構築できました。',
	'all rows' => 'すべての行',
	'All times are displayed in GMT' => '時刻はすべて協定世界時 (世界標準時) から次の時間分ずれています: ',
	'All times are displayed in GMT.' => '時刻はすべて協定世界時 (世界標準時)です。',
	'all weblogs' => 'すべてのブログ',
	'Allow Comments' => 'コメントの受信',
	'Allow HTML' => 'HTMLの利用を許可',
	'Allow outbound TrackBacks to:' => 'トラックバックの送信: ',
	'Allow TrackBacks' => 'トラックバックの受信',
	'An author by that name already exists.' => 'そのログイン名の投稿者はすでに存在しています。',
	'An error occurred' => 'エラーが発生しました',
	'An error occurred during the import process: [_1]. Please check your import file.' => '記事の読み込みに失敗しました: [_1]. 読み込むファイルの内容を確認してください。',
	'An error occurred:' => 'エラーが発生しました: ',
	'An error occurred: [_1]' => 'エラーが発生しました: [_1]',
	'An invalid redirect parameter was provided. The weblog owner needs to specify a path that matches with the domain of the weblog.' => '設定に誤りがあります。メール送信の設定を確認してください。',
	'An unapproved comment has been posted on your blog [_1], for entry #[_2] ([_3]). You need to approve this comment before it will appear on your site.' => '「[_3] (ブログ: [_1]、エントリーID: [_2])」への未承認のコメントを受け付けました。コメントを公開するためには承認をしてください。',
	'An unapproved TrackBack has been posted on your blog [_1], for category #[_2], ([_3]). You need to approve this TrackBack before it will appear on your site.' => '「[_3] (ブログ: [_1]、カテゴリーID: [_2])」への未承認のトラックバックを受け付けました。トラックバックを公開するためには承認をしてください。',
	'An unapproved TrackBack has been posted on your blog [_1], for entry #[_2] ([_3]). You need to approve this TrackBack before it will appear on your site.' => '「[_3] (ブログ: [_1]、エントリーID: [_2])」への未承認のトラックバックを受け付けました。トラックバックを公開するためには承認をしてください。',
	'Anonymous' => '匿名',
	'Another amount...' => '行数を指定',
	'Any authenticated commenters' => '認証サービスで認証されたコメント投稿者のみ',
	'Any site' => 'すべてのサイトへのトラックバックを許可する',
	'Anyone' => 'すべて',
	'API Password:' => 'APIパスワード: ',
	'Application log for blog \'[_1]\' reset by \'[_2]\' (user #[_3])' => '[_2]によりログが初期化されました (ブログ: [_1])',
	'Application log reset by \'[_1]\' (user #[_2])' => '[_1] (ID: [_2]) によりログが初期化されました',
	'Approve this comment:' => 'コメントを承認: ',
	'Approve this TrackBack:' => 'トラックバックを承認: ',
	'Approved' => '承認済',
	'Archive File Path' => '出力フォーマット',
	'archive map' => 'アーカイブ・マッピング',
	'Archive Mapping' => 'アーカイブ・マッピング',
	'archive maps' => 'アーカイブ・マッピング',
	'Archive Root:' => 'アーカイブ・パス: ',
	'Archive Templates' => 'アーカイブ・テンプレート',
	'Archive templates are used for producing multiple pages of the same archive type.  You can create new ones and map them to archive types on the publishing settings screen for this weblog.' => 'アーカイブ・テンプレートは、同一のアーカイブの種類でも異なるページを生成できます。また、新しく作成したアーカイブ・テンプレートに、ブログの公開の設定にあるアーカイブ・マッピング機能を適用すると、異なるアーカイブの種類にマップしたページもできます。',
	'Archive type \'[_1]\' is not a chosen archive type' => 'アーカイブの種類「[_1]」はアーカイブの設定で選択されていません。',
	'Archive Type:' => 'アーカイブの種類: ',
	'Archive Types' => 'アーカイブ種類',
	'Archive URL:' => 'アーカイブURL: ',
	'Archives' => 'アーカイブ',
	'Are you sure you want to delete the [quant,_1,blocked item,blocked items]?' => '[quant,_1,件,件]のアイテムを削除していいですか?',
	'Are you sure you want to delete the [quant,_1,category,categories]? When you delete a category, all entries assigned to that category will be unassigned from that category.' => '[quant,_1,件,件]のカテゴリーを削除していいですか? カテゴリーを削除すると、そのカテゴリーに属するエントリーは、そのカテゴリーが指定されていない状態になります。',
	'Are you sure you want to delete the [quant,_1,comment]?' => '[quant,_1,件,件]のコメントを削除していいですか?',
	'Are you sure you want to delete the [quant,_1,entry,entries]?' => '[quant,_1,件,件]のエントリーを削除していいですか?',
	'Are you sure you want to delete the [quant,_1,IP address,IP addresses] from your Banned IP List?' => '[quant,_1,件,件]のアドレスを禁止IPアドレスリストから削除していいですか?',
	'Are you sure you want to delete the [quant,_1,notification address,notification addresses]?' => '[quant,_1,件,件]の通知先メールアドレスを削除していいですか?',
	'Are you sure you want to delete the [quant,_1,template] from the particular archive type(s)?' => 'このアーカイブの種類の[quant,_1,件,件]のテンプレートを削除していいですか?',
	'Are you sure you want to delete the [quant,_1,template]?' => '[quant,_1,件,件]のテンプレートを削除していいですか?',
	'Are you sure you want to delete the [quant,_1,TrackBack]?' => '[quant,_1,件,件]のトラックバックを削除していいですか?',
	'Are you sure you want to delete the [quant,_1,weblog]? When you delete a weblog, all of the entries, comments, templates, notifications, and author permissions are deleted along with the weblog itself. Make sure that this is what you want, because this action is permanent.' => '[quant,_1,件,件]のブログを削除していいですか? ブログを削除すると、すべてのエントリー、コメント、テンプレート、通知先のアドレス帳、投稿者の権限の情報も一緒に削除されます。削除すると元に戻せませんから、よく確認してから削除してください。',
	'Are you sure you want to permanently delete the [quant,_1,author] from the system?' => '[quant,_1,人,人]の投稿者をシステムから完全に削除していいですか?',
	'Are you sure you want to reset the settings for this plugin?' => 'このプラグインの設定を初期化しますか?',
	'Ascending' => '昇順',
	'Assign &gt;&gt;' => '追加 &gt;&gt;',
	'Assign Multiple Categories' => '複数のカテゴリーを指定する',
	'Assigning author types...' => 'データベースをアップグレードします: 投稿者の種別',
	'Assigning blog administration permissions...' => 'データベースをアップグレードします: ブログ管理者の権限',
	'Assigning category parent fields...' => 'データベースをアップグレードします: カテゴリー親フィールド',
	'Assigning comment/moderation settings...' => 'データベースをアップグレードします: コメント保留の設定',
	'Assigning custom dynamic template settings...' => 'データベースをアップグレードします: ダイナミック・テンプレートの設定',
	'Assigning entry basenames for old entries...' => 'データベースをアップグレードします: 既存エントリーのファイル名',
	'Assigning junk status for comments...' => 'データベースをアップグレードします: コメントの状態',
	'Assigning junk status for TrackBacks...' => 'データベースをアップグレードします: トラックバックの状態',
	'Assigning permissions for new author...' => '新しい投稿者の権限を設定します。',
	'Assigning template build dynamic settings...' => 'データベースをアップグレードします: ダイナミック・パブリッシングの設定',
	'Assigning visible status for comments...' => 'データベースをアップグレードします: 迷惑コメントのスコア設定',
	'Assigning visible status for TrackBacks...' => 'データベースをアップグレードします: 迷惑トラックバックのスコア設定',
	'at' => '日時:',
	'Authenticated' => '認証済み',
	'authenticated' => '認証済み',
	'Authenticated Commenters' => '認証サービスで認証されたコメント投稿者',
	'Authenticated commenters only' => '認証サービスで認証されたコメント投稿者のみ',
	'Authentication Enabled' => '認証サービスを利用できます',
	'Authentication is enabled.' => '認証サービスを利用できます。',
	'Authentication is not enabled.' => '認証サービスを利用できません。',
	'Authentication Not Enabled' => '認証サービスを利用できません',
	'Authentication Status' => '認証サービスの設定',
	'Authentication Token Inserted' => '認証用トークンが入力されました。',
	'Authentication Token Removed' => '認証用トークンが削除されました。',
	'Authentication Token:' => '認証用トークン: ',
	'Author' => '投稿者',
	'author' => '投稿者',
	'Author does not have email address' => 'メールアドレスが登録されていません',
	'Author has not set birthplace; cannot recover password' => 'パスワード・ヒントが設定されていないので、パスワードの再設定ができません',
	'Author name or birthplace is incorrect.' => 'ログイン名またはパスワード・ヒントが正しくありません。',
	'Author of [_1]' => 'プラグイン作成者',
	'Author Permissions' => '投稿者の権限',
	'Author Profile' => '投稿者のプロフィール',
	'Author requires password' => 'パスワードが入力されていません。',
	'Author requires password hint' => 'パスワード・ヒントが入力されていません',
	'Author requires username' => 'ログイン名が入力されていません。',
	'Authored On' => '投稿日',
	'Authors' => '投稿者',
	'authors' => '投稿者',
	'Auto-Delete Junk' => '自動削除',
	'Auto-Link URLs' => 'URLを自動的にリンク',
	'Bad CGIPath config' => 'CGIPathの設定に誤りがあります。設定を確認してください。',
	'Bad ObjectDriver config' => 'データベース接続の設定に誤りがあります。設定を確認してください。',
	'Bad ObjectDriver config: [_1] ' => 'データベース接続の設定に誤りがあります: [_1]',
	'Ban' => '禁止する',
	'Ban commenter' => '投稿を禁止する',
	'Ban Commenter(s)' => '投稿を禁止する',
	'Ban IP Address' => 'アドレスを登録する',
	'Ban New IP Address' => 'アドレスを新規登録',
	'Ban selected commenters' => '投稿を禁止する',
	'Ban This IP' => 'このIPアドレスを禁止する',
	'Ban&nbsp;Commenter' => '禁止する',
	'Banned' => '禁止中',
	'banned' => '禁止中',
	'Basename' => 'エントリー・ファイル名',
	'Basename Length:' => 'ファイル名の最大長: ',
	'Basic' => '基本',
	'Be sure that you understand these licenses before applying them to your own work.' => 'ライセンスを設定する前に、これらのライセンスを利用することは、あなたの責任になることを理解した上で設定してください。',
	'Before you can begin blogging, we need to complete your installation by initializing your database.' => 'ブログを始める前に、データベースを初期化してインストール作業を完了する必要があります。',
	'Begin Upgrade' => 'アップグレードの開始',
	'Below' => '下',
	'Below is the list of people who wish to be notified when you post to your site. To delete an address, check the Delete box and press the Delete button.' => 'お知らせメールを送信する先の一覧です。',
	'Below you find a list of all weblogs in the system with links to the main weblog page and individual settings pages for each.  You may also create or delete blogs from this screen.' => 'この画面では、すべてのブログを一覧できるほか、ブログを新規に作成したり、削除ができます。ブログ名をクリックすると、スタート・ページが開き、個々のブログの操作ができます。',
	'Block' => 'ブロック',
	'Blocked' => 'ブロック',
	'Blog Administrator' => 'ブログの管理者',
	'Blog Name' => 'ブログ名',
	'Bold' => '太字',
	'Both' => '両方',
	'Bottom of the page' => '編集画面の下',
	'Build all templates statically' => 'すべてをスタティックHTMLで出力します',
	'Build error in template \'[_1]\': [_2]' => 'テンプレート「[_1]」の再構築に失敗しました: [_2]',
	'Build error: [_1]' => '再構築エラー: [_1]',
	'Build only Archive Templates dynamically' => 'アーカイブのみダイナミック・パブリッシングで出力します',
	'Build Options' => '再構築オプション',
	'Building archive failed: [_1]' => 'アーカイブの再構築に失敗しました: [_1]',
	'Building category \'[_1]\' failed: [_2]' => 'カテゴリー・アーカイブ「[_1]」の再構築に失敗しました: [_2]',
	'Building category archives, but no category provided.' => 'カテゴリー・アーカイブを構築しようとしましたが、カテゴリーがありません。',
	'Building date-based archive \'[_1]\' failed: [_2]' => '日付アーカイブ「[_1]」の再構築に失敗しました: [_2]',
	'Building entry \'[_1]\' failed: [_2]' => 'エントリー・アーカイブ「[_1]」の再構築に失敗しました: [_2]',
	'Building results failed: [_1]' => '結果の表示ができません: [_1]',
	'Building template failed: [_1]' => 'テンプレートの再構築に失敗しました: [_1]',
	'Built w/Indexes' => '再構築',
	'Button Bar Position' => '「保存」「確認」ボタンの位置',
	'By default, this search engine looks for all words in any order. To search for an exact phrase, enclose the phrase in quotes:' => 'すべての言葉が含まれるページを検索します。言葉を検索するときは、引用符で囲んでください。',
	'Callback died: [_1]' => 'コールバック先が使えません: [_1]',
	'Can\'t approve/ban non-COMMENTER author' => '承認/禁止はコメント投稿者にしか設定できません。',
	'Can\'t create RSS feed \'[_1]\': ' => 'RSSフィード「[_1]」を作成できません',
	'Can\'t delete that way' => 'この方法では削除できません',
	'Can\'t find default template list; where is \'default-templates.pl\'?' => 'デフォルト・テンプレートの一覧default-tempaltes.plが見つかりません。',
	'Can\'t find default template list; where is \'default-templates.pl\'? Error: [_1]' => 'デフォルト・テンプレートの一覧default-tempaltes.plが見つかりません: [_1]',
	'Can\'t find entry \'[_1]\'' => 'エントリー「[_1]」が見つかりません。',
	'Can\'t find existing entry with timestamp [_1]... skipping comments, and moving on to next entry.' => 'タイムスタンプが ([_1]) のエントリーは見つからないため、コメントの追加ができません。次に進みます。',
	'Can\'t find existing entry with timestamp \'[_1]\'... skipping comments, and moving on to next entry.\n' => '「[_1]」のエントリーが見つかりません。このコメントの登録は除き、次のエントリーに移動します。',
	'Can\'t find included file \'[_1]\'' => '読み込むファイル「[_1]」が見つかりません',
	'Can\'t find included template module \'[_1]\'' => '読み込むテンプレート・モジュール「[_1]」が見つかりません。',
	'Can\'t find template \'[_1]\'' => 'テンプレート「[_1]」が見つかりません',
	'Can\'t load \'[_1]\' template.' => 'テンプレートを利用できません: [_1]',
	'Can\'t load Image::Magick: [_1]' => '「Image::Magick」を利用できません: [_1]',
	'Can\'t load IPC::Run: [_1]' => '「IPC::Run」を利用できません: [_1]',
	'Can\'t load template [_1]' => 'テンプレートを利用できません: [_1]',
	'Can\'t make path \'[_1]\': [_2]' => 'パス[_1]を作成できません: [_2]',
	'Can\'t open \'[_1]\': [_2]' => 'ファイル[_1]を開けません: [_2]',
	'Can\'t open directory \'[_1]\': [_2]' => 'ディレクトリー[_1]を開けません: [_2]',
	'Can\'t open file \'[_1]\': [_2]' => 'ファイル[_1]を開けません: [_2]',
	'Can\'t rewind' => '読み込み中にエラーが発生しました。',
	'Cancel' => '取り消し',
	'Cannot find sort_method' => 'ソートができません。',
	'Case Sensitive' => '大文字/小文字を区別する',
	'Categories' => 'カテゴリー',
	'categories' => 'カテゴリー',
	'Categories in your weblog:' => 'ブログのカテゴリー: ',
	'Categories must exist within the same blog' => 'カテゴリーが見つかりません。',
	'category' => 'カテゴリー',
	'Category Description' => 'カテゴリーの説明',
	'Category Label' => 'カテゴリー名',
	'Category loop detected' => 'カテゴリー・ループエラーが発生しました。',
	'Category name cannot be blank.' => 'カテゴリー名を設定してください。',
	'Category no longer exists' => 'カテゴリーは存在しません。',
	'Category Title:' => 'カテゴリーのタイトル: ',
	'CGI is required for all Movable Type application functionality.' => '「CGI」は、Movable Typeのすべての機能で必要です。',
	'CGI Path Configuration Required' => '「CGIPath」の設定が必要です。',
	'CGI::Cookie is required for cookie authentication.' => '「CGI::Cookie」は、Cookie認証のために必要です。',
	'Change this message.' => 'このメッセージを変更する',
	'Change your license' => 'ライセンスを変更する',
	'Check All' => 'すべてを選択',
	'Checking for [_1] Modules:' => 'モジュールの確認: [_1]',
	'Choose a Destination' => 'アップロード先を指定',
	'Choose a File' => 'ファイルを指定',
	'Clear Authentication Token' => '認証用トークンの消去',
	'Click on the author\'s name to edit the comment. To delete a comment, check the box to its right and then click the Delete button.' => 'コメント投稿者の名前をクリックすると内容を編集できます。削除したいコメントを選んで「削除」ボタンをクリックしてください。',
	'Click on the TrackBack title to view the page. To delete a TrackBack, check the box to its right and then click the Delete button.' => 'トラックバックのタイトルをクリックしてページを表示します。トラックバックを削除するには、右側にあるチェックボックスをオンにして「削除」ボタンをクリックします。',
	'Close' => '閉じる',
	'Collapse' => '折りたたむ',
	'Comment' => 'タイトル',
	'comment' => 'コメント',
	'Comment authentication is not available because one of the needed modules, MIME::Base64 or LWP::UserAgent is not installed. Talk to your host about getting this module installed.' => '認証に必要なモジュール「MIME::Base64」または「LWP::UserAgent」がインストールされていないため、コメントの認証は利用できません。',
	'Comment Error Template' => 'コメント・エラー',
	'Comment Listing Template' => 'コメントの一覧',
	'Comment on' => 'コメント: ',
	'Comment on missing entry!' => '削除されたエントリーへのコメント投稿です。',
	'Comment Order:' => 'コメントの表示順: ',
	'Comment Pending Template' => 'コメント・保留',
	'Comment Preview Template' => 'コメント・プレビュー',
	'Comment Text' => 'コメント本文',
	'Comment text is required.' => 'コメントの本文を入力してください。',
	'commenter' => 'コメント投稿者',
	'Commenter' => 'コメント投稿者',
	'Commenter Details' => 'コメント投稿者について',
	'Commenter Registration Template' => 'コメント投稿者・登録',
	'Commenter:' => '名前: ',
	'commenters' => 'コメント投稿者',
	'Commenters' => 'コメント投稿者',
	'commenters where' => 'コメント投稿者‐検索条件: ',
	'commenters.' => 'コメント投稿者',
	'Comments' => 'コメント',
	'comments' => 'コメント',
	'Comments ([_1])' => 'コメント ([_1])',
	'Comments and TrackBacks receive a junk score between -10 (complete junk) and +10 (not junk). Feedback with a score which is lower than the threshold shown above will be marked as junk.' => '受け付けたコメントとトラックバックには、迷惑の度合いが評価されます。評価値は、-10 (迷惑度: 最大) から+10 (迷惑度: ゼロ) までの範囲の数値です。指定した判断基準値より低い値のコメントとトラックバックは、迷惑コメント/トラックバックと見なされます。',
	'Comments are not allowed on this entry.' => 'このエントリーにコメントはできません。',
	'comments where' => 'コメント‐検索条件: ',
	'comments.' => 'コメント',
	'Comments:' => 'コメント: ',
	'Community' => 'コミュニティ',
	'Compact' => 'コンパクト',
	'Composite score: [_1]' => 'スコア集計値: [_1]',
	'Concise listing of weblogs.' => '登録しているブログの一覧です。',
	'Config directive [_1] without value at [_2] line [_3]' => '環境変数「[_1]」が未設定です。(ファイル: [_2])、[_3]行目)',
	'Configure' => '環境設定',
	'Configure QuickPost' => '「クイック投稿」を設定する',
	'Configure this weblog.' => 'はじめにブログを設定してください。',
	'Configure Weblog' => 'ブログの設定',
	'Connection error: [_1]' => 'エラーが発生しました: [_1]',
	'Constrain proportions' => '縦横比を固定する',
	'Continue reading' => '続きを読む',
	'Convert Line Breaks' => '改行を変換する',
	'Copy and paste this HTML into your entry.' => 'このHTMLをコピーしてエントリーに貼りつけてください。',
	'Could not create atom id for entry [_1]' => '次のエントリーのためのAtom IDを生成できません: [_1]',
	'Could not determine entry' => 'エントリーが見つかりません。',
	'Couldn\'t get daily archive list' => '日付アーカイブのリストが見つかりません。',
	'Couldn\'t get monthly archive list' => '月別アーカイブのリストが見つかりません。',
	'Couldn\'t get public key from url provided' => '指定したURLから公開鍵を取得できません。',
	'Couldn\'t get weekly archive list' => '週別アーカイブのリストが見つかりません。',
	'Couldn\'t save the session' => '現在のセッションを保存できません。',
	'Count [_1] failed on SQL error [_2]' => '「[_1]」でSQLエラーが発生しました: [_2]',
	'Create' => '作成',
	'Create a license now' => 'ライセンスを設定する',
	'Create a new entey on this weblog' => 'エントリーを投稿',
	'Create a new entry' => 'エントリーを投稿',
	'Create a new entry using this uploaded file' => 'エントリーを投稿',
	'Create a thumbnail for this image' => 'この画像のサムネイルを作る',
	'Create Category' => 'カテゴリーを作成',
	'Create New Archive Mapping' => 'マッピングを新規作成',
	'Create New Archive Template' => 'テンプレートを新規作成',
	'Create new archive template' => 'テンプレートを新規作成',
	'Create New Author' => '投稿者を新規登録',
	'Create New Entry' => 'エントリーを投稿',
	'Create New Index Template' => 'テンプレートを新規作成',
	'Create new index template' => 'テンプレートを新規作成',
	'Create New Notification' => '通知先を新規登録',
	'Create New Template Module' => 'モジュールを新規作成',
	'Create new template module' => 'モジュールを新規作成',
	'Create new top level category' => 'トップレベル・カテゴリーを作成',
	'Create New Weblog' => 'ブログを新規作成',
	'Create Subcategory' => 'サブカテゴリーを作成',
	'Create template requires type' => 'テンプレートを作成する際は、テンプレートの種類を指定してください。',
	'Create Weblogs' => 'ブログの作成',
	'Create, manage, set permissions.' => '登録している投稿者の一覧です。',
	'Created By' => '作成者: ',
	'Creating configuration record.' => '環境を設定しています',
	'Creating entry category placements...' => 'アップグレード中: カテゴリー関連の設定',
	'Creating initial weblog and author records...' => 'ブログと管理者の初期値を登録します。',
	'Creating new author (\'' => '新しく投稿者を登録します: [_1]',
	'Creating new author (\'[_1]\')...' => '新しい投稿者[_1]を登録します。',
	'Creating new authors for each author found in the blog' => '読み込む記事に設定されている投稿者を新たに作成します。',
	'Creating new category (\'[_1]\')...' => '新しいカテゴリー「[_1]」を登録します。',
	'Creating new comment (from \'[_1]\')... ' => '[_1]からの新しいコメントを登録します。',
	'Creating new ping (\'[_1]\')... ' => '新しいトラックバック「[_1]」を登録します。',
	'Creating new template: \'[_1]\'.' => 'デフォルト・テンプレート「[_1]」を登録します。',
	'Creating template maps...' => 'テンプレート・マッピングを設定します。',
	'Creation Order' => '作成日',
	'Creative Commons License' => 'クリエイティブ・コモンズ・ライセンス',
	'Creative Commons License:' => 'クリエイティブ・コモンズ・ライセンス: ',
	'Crypt::DSA is optional; if it is installed, comment registration sign-ins will be accelerated.' => '「Crypt::DSA」をインストールすると、コメント登録機能を利用するときに、TypeKeyを利用したサインインの動作が高速になります。',
	'Current Password:' => '現在のパスワード: ',
	'Current working directory:' => 'CGIが動作しているディレクトリー: ',
	'Custom...' => 'カスタマイズする',
	'Custom: show the following fields:' => 'カスタム - 以下の入力項目を表示する: ',
	'Customize the display of this page.' => '画面の表示設定を変更',
	'Czech' => 'チェコ語',
	'Danish' => 'デンマーク語',
	'Data Storage' => 'データ管理',
	'Database Connection Error' => 'データベースに接続できません。',
	'Database has been upgraded to version [_1].' => '完了しました: バージョン: [_1]',
	'Date' => '日付',
	'Date Added' => '作成日',
	'Date Banned' => '禁止日',
	'Date Display:' => '日付表示: ',
	'Date Language:' => '日付表示用の言語: ',
	'Date Range' => '日付範囲',
	'Date Range:' => '日付範囲: ',
	'Date:' => '日付: ',
	'days' => '日',
	'Days' => '日分',
	'DB_File is required if you want to use the Berkeley DB/DB_File backend.' => '「DB_File」は、Berkley DB/DB_Fileを使ってブログのデータを管理するために必要です。',
	'DBI and DBD::mysql are required if you want to use the MySQL database backend.' => '「DBI」と「DBD::mysql」は、MySQLを使ってブログのデータを管理するために必要です。',
	'DBI and DBD::Pg are required if you want to use the PostgreSQL database backend.' => '「DBI」と「DBD::Pg」は、PostgreSQLを使ってデータを管理するために必要です。',
	'DBI and DBD::SQLite are required if you want to use the SQLite database backend.' => '「DBI」と「DBD::SQLite」は、SQLiteを使ってデータを管理するために必要です。',
	'DBI is required if you want to use any of the SQL database drivers.' => '「DBI」は、SQL対応のデータベースを使ってデータを管理するために必要です。',
	'Decrease' => '増やす',
	'Default category for entries (optional):' => 'カテゴリーの初期値 (オプション): ',
	'Default post status for entries (optional):' => '投稿の状態の初期値 (オプション): ',
	'Default Settings for New Entries' => 'エントリーを新規に投稿したときの初期値',
	'Default Weblog Display Settings' => '表示に関する初期設定',
	'Delete' => '削除',
	'Delete Junk After' => '削除するまでの日数',
	'Delete selected authors (d)' => '選択した投稿者を削除 (D)',
	'Delete selected categories (d)' => '選択したカテゴリーを削除 (D)',
	'Delete selected comments (d)' => '選択したコメントを削除 (D)',
	'Delete selected entries (d)' => '選択したエントリーを削除 (D)',
	'Delete selected notification addresses (d)' => '選択した通知先アドレスを削除 (D)',
	'Delete selected TrackBacks (d)' => '選択したトラックバックを削除 (D)',
	'Delete selected weblogs (d)' => '選択したブログを削除 (D)',
	'Delete this comment (d)' => 'コメントを削除 (D)',
	'Delete this entry (d)' => 'エントリーを削除 (D)',
	'Delete this TrackBack (d)' => 'トラックバックを削除 (D)',
	'Descending' => '降順',
	'Description' => '説明',
	'Description:' => 'ブログの説明: ',
	'Disable' => '利用しない',
	'Disable Comments' => 'コメントの受信',
	'Disable plugin system?' => 'プラグインの利用をやめますか?',
	'Disable Plugins' => 'プラグインを利用しない',
	'Disable this plugin?' => 'このプラグインの利用をやめますか?',
	'Disable TrackBacks' => 'トラックバックの受信',
	'Disabled' => '利用不可',
	'Display Name:' => '表示名: ',
	'Display Options' => '表示オプション',
	'Documentation' => 'ドキュメント',
	'Documentation for [_1]' => 'プラグイン「[_1]」のドキュメント',
	'Download file' => 'ダウンロードしたファイル',
	'Dutch' => 'オランダ語',
	'Dynamic' => 'ダイナミック',
	'Dynamic Pages Error Template' => 'ダイナミックページ・エラー',
	'Dynamic Publishing:' => '再構築オプション: ',
	'Edit All Entries' => 'エントリーの編集',
	'Edit Authors & Permissions' => '投稿者と権限の編集',
	'Edit Categories' => 'カテゴリーを編集',
	'Edit Comment' => 'コメントを編集',
	'Edit Entry' => 'エントリーを編集',
	'Edit Notification List' => '通知先を編集',
	'Edit Permissions' => '権限を変更',
	'Edit System Settings' => 'システム設定を変更',
	'Edit Template' => 'テンプレートを編集',
	'Edit this comment' => 'コメントを編集',
	'Edit this comment:' => 'コメントを編集',
	'Edit this commenter' => 'コメント投稿者の情報を修正',
	'Edit this entry' => 'エントリーを編集',
	'Edit this TrackBack' => 'トラックバックを編集',
	'Edit this TrackBack:' => 'トラックバックを編集',
	'Edit TrackBack' => 'トラックバックを編集',
	'Edit Weblog Configuration' => 'ブログを設定',
	'Editable Authored On Date' => '日付を編集',
	'Either your server does not have [_1] installed, the version that is installed is too old, or [_1] requires another module that is not installed.' => 'サーバーに、「[_1]」がインストールされていない、古いバージョンがインストールされている、もしくは「[_1]」に必要なモジュールがインストールされていません',
	'Email' => 'Email',
	'Email Address' => 'メールアドレス',
	'E-mail Address' => 'メールアドレス',
	'Email Address (*):' => 'メールアドレス (*): ',
	'Email Address is required for password recovery' => 'メールアドレスは、パスワードを再設定するために必要です。',
	'Email Address:' => 'メールアドレス: ',
	'E-mail Notification' => 'メール通知',
	'Email notifications have not been configured! The weblog owner needs to set the EmailVerificationSecret configuration variable in mt.cfg.' => '設定に誤りがあります。環境設定ファイルの「EmailVerificationSecret」の設定を確認してください。',
	'Email:' => 'Email: ',
	'Embedded Image' => '埋め込み',
	'Enable' => '利用する',
	'Enable dynamic building for this template' => 'このテンプレートをダイナミック・ページにする',
	'Enable External TrackBack Auto-Discovery' => '外部のリンクに対するトラックバック自動検知を有効にする',
	'Enable Internal TrackBack Auto-Discovery' => '内部のリンクに対するトラックバック自動検知を有効にする',
	'Enable one-click publishing.' => 'クイック投稿を使うと、1クリックで投稿できます。',
	'Enable plugin system?' => 'プラグインを利用しますか?',
	'Enable Plugins' => 'プラグインを利用する',
	'Enable this plugin?' => 'このプラグインを利用しますか?',
	'Enabled' => '利用可',
	'End title HTML (optional):' => '最後のタイトルHTML (オプション): ',
	'English' => '英語',
	'Enter a description for your weblog.' => 'このブログに対する説明文/紹介文を入力してください。',
	'Enter the archive file extension. This can take the form of \'html\', \'shtml\', \'php\', etc. Note: Do not enter the leading period (\'.\').' => 'アーカイブ・ファイルの拡張子を入力してください。html、shtml、phpなどを設定できます。先頭の.(ピリオド) は入力しないでください。',
	'Enter the existing password to change it.' => '変更前 (現在) のパスワードを入力してください。',
	'Enter the number of words that should appear in an auto-generated excerpt.' => '概要を自動生成するときの文字数を入力してください。',
	'Enter the path where your archive files will be published.' => 'アーカイブ・ファイルを置くパス名を入力してください。',
	'Enter the path where your index files will be published. An absolute path (starting with \'/\') is preferred, but you can also use a path relative to the Movable Type directory.' => 'メインページ (index.html) を置くパス名を入力してください。絶対パス (/で始まる) をお勧めしますが、Movable Typeがインストールされた場所からの相対パスも使えます。',
	'Enter the path where your main index file will be located. An absolute path (starting with \'/\') is preferred, but you can also use a path relative to the Movable Type directory.' => 'メインページ (index.html) をおくパス名を入力してください。絶対パス (/で始まる) をお勧めしますが、Movable Typeがインストールされた場所からの相対も使えます。',
	'Enter the URL of the archives section of your website.' => 'ウェブサイトでアーカイブ・ファイルにアクセスするためのURLを入力してください。',
	'Enter the URL of your public website. Do not include a filename (i.e. exclude index.html).' => 'このブログを公開するサイトのURLを入力してください。ファイル名 (index.htmlなど) は入力しないでください。',
	'Enter the URL of your website. Do not include a filename (i.e. exclude index.html).' => 'このブログを公開するサイトのURLを入力してください。ファイル名 (index.htmlなど) は入力しないでください。',
	'Enter the URL(s) of the websites that you would like to send a TrackBack to each time you post an entry in this category. (Separate URLs with a carriage return.)' => 'このカテゴリーで新規投稿する際に、トラックバックを自動送信する場合は、送信先のURLを入力してください。(複数のURLを入力する場合は改行してください)',
	'Enter your Movable Type username:' => 'ログイン名を入力してください: ',
	'Enter your password hint:' => 'パスワード・ヒントを入力してください: ',
	'Entries' => 'エントリー',
	'entries' => 'エントリー',
	'Entries to Display:' => '表示数: ',
	'entries where' => 'エントリー‐検索条件: ',
	'entries.' => 'エントリー',
	'Entry' => 'エントリー',
	'entry' => 'エントリー',
	'Entry [_1] is not published' => '指定のエントリーは公開されていません (エントリーID: [_1])',
	'entry \'[_1]\'' => 'エントリー・アーカイブ「[_1]」',
	'Entry Body' => 'エントリーの内容 (body)',
	'Entry Creation' => 'エントリーの投稿',
	'Entry has no MT::Trackback object!' => 'エントリーにはMT::Trackbackオブジェクトがありません。',
	'Entry no longer exists' => 'エントりーはすでにありません',
	'Entry Order:' => 'エントリーの表示順: ',
	'Entry:' => 'エントリー: ',
	'Error' => 'エラー',
	'Error creating temporary file; please check your TempDir setting in mt.cfg (currently \'[_1]\') this location should be writable.' => 'テンポラリーファイルを作成できません。環境設定ファイルのTempDirの設定値 (現在の設定は[_1]) を確認してください。また、設定したディレクトリーが書き込み可能か確認してください。',
	'Error deleting \'[_1]\': [_2]' => '「[_1]」を削除できません: [_2]',
	'Error during installation:' => 'インストール中にエラーが発生しました: ',
	'Error during upgrade:' => 'アップグレード中にエラーが発生しました: ',
	'Error during upgrade: [_1]' => 'アップグレード中にエラーが発生しました: [_1]',
	'Error in <MT[_1]> tag: [_2]' => '<MT[_1]>タグでエラーが発生しました: [_2]',
	'Error in file template: [_1]' => 'テンプレートファイルでエラーが発生しました: [_1]',
	'Error loading [_1]: [_2]' => '[_1]のロードでエラーが発生しました: [_2]',
	'Error loading class: [_1].' => 'プログラム・モジュールをロードしているときにエラーが発生しました: [_1]',
	'Error making path \'[_1]\': [_2]' => 'ディレクトリー[_1]の作成に失敗しました: [_2]',
	'Error opening \'[_1]\': [_2]' => '[_1]を開けません: [_2]',
	'Error opening file \'[_1]\': [_2]' => '[_1]を開けません: [_2]',
	'Error opening included file \'[_1]\': [_2]' => '読み込むファイル[_1]を開けません: [_2]',
	'Error saving record: [_1].' => 'レコードの保存中にエラーが発生しました: [_1]',
	'Error saving setting: No domains to limit outboud' => 'トラックバックの送信先を指定していません。',
	'Error sending mail ([_1]); please fix the problem, then try again to recover your password.' => 'メール送信のエラー ([_1]) が発生しました。メールの設定を確認してから、もう一度試してください。',
	'Error sending mail ([_1]); try another MailTransfer setting?' => 'メール送信のエラー ([_1]) が発生しました。別の設定でも確認してください。',
	'Error sending mail: [_1]' => 'メールの送信エラー: [_1]',
	'Error sorting categories: [_1]' => 'カテゴリーのソートでエラーが発生しました: [_1]',
	'Error writing to \'[_1]\': [_2]' => '「[_1]」への書き込みができません: [_2]',
	'Error writing upload to \'[_1]\': [_2]' => '「[_1]」へのアップロードができません: [_2]',
	'Error: Movable Type was not able to create a directory for publishing your weblog. If you create this directory yourself, assign sufficient permissions that allow Movable Type to create files within it.' => 'エラー: ブログ公開用のパスを作成できません。パスを設定する場合は、Movable Typeがそのサイト・パス内にファイルを作成できるように、権限を設定してください。',
	'Essential Links' => 'リンク集',
	'Establish a link between your weblog and an authentication service. You may use TypeKey (a free service, available by default) or another compatible service.' => 'TypeKeyまたは互換のコメント認証サービスを利用するための、認証用トークンを入力してください。',
	'Estonian' => 'エストニア語',
	'Example:' => '例: ',
	'Excerpt' => '概要 (excerpt)',
	'Excerpt Length:' => '概要にいれる文字数: ',
	'Excerpt:' => '概要: ',
	'Exec of sendmail failed: [_1]' => 'sendmailの実行に失敗しました: [_1]',
	'Execute failed' => 'エラーが発生しました。',
	'Executing SQL: [_1];' => '次のSQLを実行中です: [_1]',
	'existence test failed on SQL error [_1]' => 'SQLエラーが発生しました: [_1]',
	'Expand' => '展開',
	'Expanded' => '拡張',
	'Export Entries' => 'エントリーの書き出し',
	'Export Entries From [_1]' => '「[_1]」からエントリーを書き出す',
	'Export Entries to Tangent' => 'Tangentにエントリーを書き出す',
	'Export failed on entry \'[_1]\': [_2]' => 'エントリー「[_1]」の書き出しに失敗しました: [_2]',
	'Export in CSV format.' => 'CSVフォーマットでの書き出し',
	'Extended Entry' => '追記 (more)',
	'Failed to generate unique ID: [_1]' => '固有のIDを生成できません: [_1]',
	'Failed to Load' => 'ロードに失敗しました。',
	'Failed to verify current password.' => '現在のパスワードを確認できません。',
	'failed\n' => '設定ができません。',
	'Feedback' => 'コメント/トラックバック',
	'Feedback Master Switch' => 'コメント/トラックバックの受信設定 (システム全体)',
	'Feedback Settings' => 'コメント/トラックバックの受信設定',
	'Field Configuration' => 'この編集画面の設定を変更',
	'File Extension for Archive Files:' => 'アーカイブの拡張子: ',
	'File with name \'[_1]\' already exists. (Install File::Temp if you\'d like to be able to overwrite existing uploaded files.)' => 'ファイル名[_1]はすでに存在しています。(ファイルを上書きする場合は、事前にFile::Tempをインストールしてください)',
	'File with name \'[_1]\' already exists; Tried to write to tempfile, but open failed: [_2]' => '[_1]という名称のファイルはすでに存在しています。テンポラリーファイルに書き込みに失敗しました. [_2]',
	'File:' => 'ファイル: ',
	'File::Spec is required for path manipulation across operating systems.' => '「File::Spec」は、オペレーション・システムに依存しないファイル・アクセスを実現するために必要です。',
	'File::Temp is optional; It is needed if you would like to be able to overwrite existing files when you upload.' => '「File::Temp」は、ファイルのアップロードで上書きするために必要です。',
	'Filter' => 'フィルター',
	'Filter:' => 'フィルター: ',
	'Final Feedback Rating' => '迷惑コメント/トラックバック自動判断値',
	'Find everything. Replace anything.' => '検索・置換ができます。',
	'Find Junk' => '迷惑コメント/トラックバック',
	'Find new comments' => 'コメントを検索',
	'Finish Install' => 'インストールを続行',
	'five months back' => '5か月前',
	'Five Most Recent Comments' => '最近のコメント',
	'Five Most Recent Entries' => '最近のエントリー',
	'Five Most Recent TrackBacks' => '最近のトラックバック',
	'For password recovery.' => 'パスワードを再設定するためのキーワードです。',
	'For use with XML-RPC and Atom-enabled clients.' => 'XML-RPCやAtom APIで利用するパスワードです。',
	'Forgot your password?' => 'パスワードの再設定',
	'four months back' => '4か月前',
	'French' => 'フランス語',
	'From' => '送信元',
	'from rule' => 'ルールから',
	'from test' => 'テストから',
	'From this screen you can specify the basic information needed to create a weblog.  Once you click the save button, your weblog will be created and you can continue to customize its settings and templates, or just simply start posting.' => 'この画面では、ブログを新しく作成するために必要な基本情報を設定できます。「変更を保存」ボタンをクリックすると、ブログが作成され、その後引き続き、詳細の設定、テンプレートのカスタマイズならびにエントリーを投稿できます。',
	'From this screen, you can view information about and manage many aspects of your system across all weblogs.' => 'システム全体の各種情報を表示し、変更できます。',
	'From:' => '開始日: ',
	'Full' => '日付',
	'Future' => '指定日',
	'General' => '基本',
	'General Permissions' => 'システム全体の権限',
	'General Settings' => '基本の設定',
	'German' => 'ドイツ語',
	'Go' => 'Go',
	'Go Back' => '戻る',
	'Go to Comment Listing' => 'コメントの一覧',
	'Go to Commenter Listing' => 'コメント投稿者の一覧',
	'Go to Publishing Settings' => '公開の設定',
	'Go to Template Listing' => 'テンプレートの一覧',
	'Go to Templates Listing' => 'テンプレートの一覧',
	'Go to the source entry of this TrackBack' => 'このトラックバックの発信元エントリーへ',
	'Google API Key:' => 'Google APIキー: ',
	'Got an error: [_1]' => 'エラーが発生しました: [_1]',
	'Group iterator failed.' => 'グループの繰り返しでエラーが発生しました。',
	'Height:' => '高さ: ',
	'Hello, [_1]' => 'こんにちは、[_1]さん',
	'Hello, world' => 'Hello, world',
	'Help' => 'ヘルプ',
	'Here is a list of the previous TrackBacks that were successfully sent:' => 'これは今までに送信できたトラックバックの一覧です: ',
	'Hold all TrackBacks for approval before they\'re published.' => '受け付けたトラックバックについて、事前に確認した後に公開する場合は、チェックしてください。',
	'HTML::Entities is needed to encode some characters, but this feature can be turned off using the NoHTMLEntities option in mt.cfg.' => '「HTML::Entities」は、いくつかの文字を変換するために必要です。環境設定ファイルの「NoHTMLEntities」を使うことで、この機能を無効にできます。',
	'HTML::Template is required for all Movable Type application functionality.' => '「HTML::Tempalte」は、Movable Typeを利用するために必要です。',
	'HTTP error: [_1]' => 'HTTPエラー: [_1]',
	'Icelandic' => 'アイスランド語',
	'Identity' => 'ID',
	'Identity:' => 'ID: ',
	'If enabled, all non-linked URLs will be transformed into links to that URL.' => '受け付けたコメント内にURLが入力されており、自動的にハイパーリンクにする場合はチェックします。(注意: コメントでのHTMLの利用を許可するをチェックしていれば、このオプションは無視されます。)',
	'If enabled, junk feedback will be automatically erased after a number of days.' => '迷惑コメント/トラックバックと判断したものを、指定の日数の後に削除します。',
	'If enabled, TrackBacks will be accepted from any source.' => 'すべてのトラックバックを受け付ける場合は、チェックしてください。',
	'If enabled, users will be able to enter a limited set of HTML in their comments. If not, all HTML will be stripped out.' => 'コメントの内容について、一部のHTMLタグの利用を許可する場合はチェックしてください。チェックしない場合は、すべてのHTMLタグが利用できなくなります。',
	'If enabled, visitors must provide a valid e-mail address when commenting.' => 'コメントの投稿時に、名前の他にメールアドレスを入力してもらう場合は、チェックしてください。',
	'If present, 3rd argument to add_callback must be an object of type MT::Plugin' => 'add_callback関数の3番目の引数は、MT::Pluginオブジェクトである必要があります。',
	'If you have a TypeKey identity, you can' => 'TypeKey IDを使って',
	'If you have a TypeKey identity, you can ' => 'TypeKey IDを使って',
	'If you have received a recently updated key (by virtue of your purchase or donation), enter it here.' => 'Recently Updatedキーがある場合、 ここに入力してください。',
	'If you need assistance, try:' => 'わからなくなったときは、次のリンクを参照してください: ',
	'If you turn on auto-discovery, when you write a new post, any external links will be extracted and the appropriate sites automatically sent TrackBacks. FIXME: Some stuff about internal vs. external' => '自動検知を設定しておくと、新しくエントリーを投稿した際に、リンクをチェックし、見つけたトラックバックURLに送信します。',
	'If you wish to use any of the Google API functionality, you will need a Google API key. Paste it in here.' => 'Google APIを利用する場合は、ここにキーを入力してください。',
	'Image Thumbnail' => 'サムネイル',
	'Image::Magick is optional; It is needed if you would like to be able to create thumbnails of uploaded images.' => '「Image::Magick」は、画像をアップロードする際のサムネイル自動作成のために必要です。',
	'Image::Size is required for file uploads (to determine the size of uploaded images in many different formats).' => '「Image::Size」は、ファイルをアップロードするために必要です。アップロードする画像のサイズを調べるために使います。',
	'Immediately publish comments from' => '即時に公開するコメント',
	'Import &amp; Export Entries' => 'エントリーの読み込み/書き出し',
	'Import / Export' => '読み込み/書き出し',
	'Import Entries' => '読み込み/書き出し',
	'Import entries as me' => 'エントリーの投稿者を自分にする',
	'Import path: ' => '読み込むファイルの保存先: ',
	'Import/Export' => '読み込み/書き出し',
	'Important:' => '重要: ',
	'Importing entries as author \'[_1]\'' => '投稿者名「[_1]」で読み込んでいます。 ',
	'Importing entries from file \'[_1]\'' => '記事を[_1]から読み込んでいます。',
	'Importing entries into blog' => 'ブログに記事を読み込んでいます',
	'Importing into existing entry ' => '既存のエントリーに書き込みます。',
	'Importing into existing entry [_1] (\'[_2]\')\n' => 'エントリー「[_2] (ID: [_1])」にコメントを追加します。',
	'Importing...' => '読み込み中...',
	'Inbound TrackBacks' => 'トラックバックの受信',
	'Include entire entry body' => '本文も送る',
	'Include excerpt' => '概要も送る',
	'Include:' => '追加項目: ',
	'Increase' => '減らす',
	'index' => 'インデックス・テンプレート',
	'index template \'[_1]\'' => 'インデックス・テンプレート「[_1]」',
	'Index Template: [_1]' => 'インデックス・テンプレート: [_1]',
	'Index Templates' => 'インデックス・テンプレート',
	'Index templates produce single pages and can be used to publish Movable Type data or plain files with any type of content. These templates are typically rebuilt automatically upon saving entries, comments and TrackBacks.' => 'インデックス・テンプレートは、Movable Typeのデータ、またはいろいろなコンテンツから1ページを生成し公開します。',
	'Indexes' => 'インデックス',
	'Initial Password (*):' => '初期パスワード (*): ',
	'Initializing database...' => 'データベースを初期化中...',
	'Insert Email Link' => 'メールアドレスを挿入',
	'Insert Link' => 'リンクを挿入',
	'Insertion test failed on SQL error [_1]' => 'SQLエラーが発生しました: [_1]',
	'Installation complete!' => 'インストールが完了しました。',
	'Installation complete.' => 'インストールが完了しました。',
	'Instructions' => '使用方法',
	'Invalid allow pings value \'[_1]\'' => 'トラックバックの読み込みに誤りがあります: [_1]',
	'Invalid Archive Type setting \'[_1]\'' => 'アーカイブの種類の設定が正しくありません: [_1]',
	'Invalid attempt to recover password (used birthplace \'[_1]\')' => '誤ったパスワード・ヒントにより、パスワードの再設定ができません。(値: [_1])',
	'Invalid author name \'[_1]\' in password recovery attempt' => '誤ったログイン名「[_1]」により、パスワードの再設定ができません。',
	'Invalid author_id' => '投稿者IDの設定に誤りがあります。',
	'Invalid basename \'[_1]\'' => 'エントリーのファイル名が正しくありません: [_1]',
	'Invalid blog' => 'ブログIDの設定に誤りがあります。',
	'Invalid category ID \'[_1]\'' => 'カテゴリーIDの設定に誤りがあります: [_1]',
	'Invalid date \'[_1]\'; authored on dates must be in the format YYYY-MM-DD HH:MM:SS.' => '日付[_1]の形式が正しくありません。日付は YYYY-MM-DD HH: MM: SS の形式で設定してください。',
	'Invalid date \'[_1]\'; authored on dates should be real dates.' => '日付 ([_1]) が正しくありません。存在しない日付が設定されています。',
	'Invalid date format \'[_1]\'; must be \'MM/DD/YYYY HH:MM:SS AM|PM\' (AM|PM is optional)' => '日付の形式[_1]が正しくありません。MM/DD/YYYY HH: MM: SS AM|PM (AM/PM はなくてもかまいません)',
	'Invalid date spec' => '日付の設定に誤りがあります。',
	'Invalid date(s) specified for date range.' => '日付範囲の設定に誤りがあります。',
	'Invalid email address \'[_1]\'' => 'メールアドレスが正しくありません: [_1]',
	'Invalid entry ID [_1]' => 'エントリーIDの設定に誤りがあります: [_1]',
	'Invalid entry ID \'[_1]\'' => 'エントリーIDが正しくありません: [_1]',
	'Invalid extra path \'[_1]\'' => 'ファイルのパス名が正しくありません: [_1]',
	'Invalid filename \'[_1]\'' => 'ファイル名が正しくありません: [_1]',
	'Invalid login attempt from user \'[_1]\'' => 'ログイン名、またはパスワードが正しくありません。',
	'Invalid login.' => 'ログインできません。',
	'Invalid month format: must be YYYYMM' => '月の表記はYYYYMM (例: 200509) にする必要があります。',
	'Invalid priority level [_1] at add_callback' => 'add_callback関数でプライオリティの設定に誤りがあります: [_1]',
	'Invalid session.' => 'データベースのバージョンに誤りがあります',
	'Invalid status value \'[_1]\'' => '状態の値が正しくありません: [_1]',
	'Invalid temp file name \'[_1]\'' => '一時ファイル名が正しくありません: [_1]',
	'Invalid TrackBack ID \'[_1]\'' => '不正なトラックバックIDです: [_1]',
	'Invalid upgrade function: [_1].' => 'アップグレード中にエラーが発生しました: [_1]',
	'Invalid URL \'[_1]\'' => '不正なURLです: [_1]',
	'IP' => 'IPアドレス',
	'IP $user_ip banned because comment rate exceeded 8 comments in [_1] seconds.\n' => '[_1]秒以内に8件以上のコメントが投稿されたので、このIPアドレスを禁止します。',
	'IP Address' => 'IPアドレス',
	'IP Address:' => 'IPアドレス: ',
	'IP addresses' => 'IPアドレス',
	'IP Banned Due to Excessive Comments' => '大量のコメントのため、この IPアドレスからのコメントの受け付けを禁止しています。',
	'IP Banning' => '禁止IPアドレス',
	'IP Banning Settings' => '禁止IPアドレスの設定',
	'IP:' => 'IPアドレス: ',
	'is' => 'が',
	'Is Junk?' => '迷惑コメント/トラックバック',
	'Italian' => 'イタリア語',
	'Italic' => 'イタリック',
	'Japanese' => '日本語',
	'Junk' => '迷惑コメント/トラックバック',
	'Junk Comments' => '迷惑コメント',
	'Junk Filter [_1] died with: [_2]' => '迷惑コメント/トラックバック・フィルター「[_1]」は、次の理由で使えません: [_2]',
	'Junk Filters' => '迷惑コメント/トラックバック・フィルター',
	'Junk Score Threshold' => '判断基準値',
	'Junk selected comments (j)' => '選択したコメントを迷惑コメントとします (J)',
	'Junk selected TrackBacks (j)' => '選択したトラックバックを迷惑トラックバックとします (J)',
	'Junk TrackBacks' => '迷惑トラックバック',
	'Junked Comment' => '迷惑コメント',
	'Junked TrackBack' => '迷惑トラックバック',
	'Keywords' => 'キーワード',
	'Knowledge Base' => '技術的なよくある質問 (FAQ)',
	'Language:' => '使用言語: ',
	'Last Entry' => '最後の投稿日時',
	'Last Updated' => '更新日',
	'Less' => '以下',
	'Less Aggressive' => 'より緩やかに',
	'Less than 1 minute ago' => '1分前まで',
	'Less than 1 minute from now' => '1分以内',
	'Limit HTML Tags:' => '許可するHTMLタグ: ',
	'Limited Fields' => '項目を指定する',
	'Link' => 'リンク',
	'Link this template to a file' => 'このテンプレートにリンクするファイル',
	'Linked' => 'リンク済み',
	'Linked Filename' => 'リンク済みファイル名',
	'List &amp; Edit Comments' => 'コメントの一覧',
	'List &amp; Edit Entries' => 'エントリーの一覧',
	'List &amp; Edit Templates' => 'テンプレートの編集',
	'List &amp; Edit TrackBacks' => 'トラックバックの一覧',
	'List Authors' => '投稿者の一覧',
	'List Commenters' => 'コメント投稿者一覧',
	'List Comments' => 'コメントの一覧',
	'List Entries' => 'エントリーの一覧',
	'List Plugins' => 'プラグインの一覧',
	'List TrackBacks' => 'トラックバックの一覧',
	'List Weblogs' => 'ブログの一覧',
	'Listed below are links to weblogs that reference' => 'この一覧は、次のエントリーを参照しています: ',
	'Load failed: ' => 'ロードに失敗しました: ',
	'Load failed: [_1]' => '読み込みに失敗しました: [_1]',
	'Load of blog \'[_1]\' failed: [_2]' => 'ブログ[_1]の読み込みに失敗しました: [_2]',
	'Load of blog failed: [_1]' => 'ブログの読み込みに失敗しました: [_1]',
	'Load of entry \'[_1]\' failed: [_2]' => 'エントリー「[_1]」の読み込みに失敗しました: [_2]',
	'Loading blog with ID [_1] failed' => 'ブログのデータをロードできません: [_1]',
	'Loading data failed with SQL error [_1]' => 'SQLエラーが発生しました: [_1]',
	'Loading object driver [_1] failed: [_2]' => 'オブジェクト・ドライバー[_1]の読み込みに失敗しました: [_2]',
	'Loading template \'[_1]\' failed: [_2]' => 'テンプレート「[_1]」の読み込みに失敗しました: [_2]',
	'Local Archive Path' => 'アーカイブ・パス',
	'Local Site Path' => 'サイト・パス',
	'Log In' => 'ログイン',
	'Log Message' => 'ログ・メッセージ',
	'log records' => 'ログ・レコード',
	'Login to Movable Type' => 'Movable Typeにログインしてください',
	'Logout' => 'ログアウト',
	'LWP::UserAgent is optional; It is needed if you wish to use the TrackBack system, the weblogs.com ping, or the MT Recently Updated ping.' => '「LWP::UserAgent」は、トラックバックや更新情報を送信するために必要です。',
	'Main' => 'メイン',
	'Main Menu' => 'メイン・メニュー',
	'Manage Categories' => 'カテゴリーの管理',
	'Manage Comments' => 'コメントの管理',
	'Manage Notification List' => '通知リストの管理',
	'Manage Templates' => 'テンプレートの管理',
	'Manage TrackBacks' => 'トラックバックの管理',
	'Mapping template ID [_1] to [_2] ([_3]).' => 'テンプレートID[_1]を[_2] ([_3]) に設定します',
	'Mapping template ID [_1] to [_2].' => 'テンプレートID[_1]を[_2]に設定',
	'Mapping templates to blog archive types...' => 'デフォルト・テンプレートをアーカイブの種類ごとに設定しています。',
	'Match case' => '大文字/小文字を区別',
	'MIME::Base64 is required in order to enable comment registration.' => '「MIME::Base64」は、コメントの登録のために必要です。',
	'Missing Configuration File' => '環境設定ファイル (mt-config.cgi) が見つかりません',
	'Missing configuration file. Maybe you forgot to move mt-config.cgi-original to mt-config.cgi?' => '環境設定ファイル (mt-config.cgi) が見つかりません。mt-config.cgi-originalからmt-config.cgiを作成していないかもしれません。',
	'Missing required parameter: blog_id. Please consult the user manual to configure notifications.' => '「blog_id」の設定に誤りがあります。ユーザー・マニュアルを参考に設定してください。',
	'Moderation' => '事前確認',
	'Module Body' => 'モジュールの内容',
	'Modules' => 'モジュール',
	'More' => '以上',
	'More about [_1]' => '「[_1]」の詳細情報',
	'More actions...' => 'その他の操作...',
	'More Aggressive' => 'より厳しく',
	'More Settings' => '続きはこちら',
	'Most Recent Comment' => '最近のコメント',
	'Movable Type Home' => 'Movable Typeホームページ',
	'Movable Type News' => 'Movable Typeニュース',
	'Movable Type Publishing Platform' => 'Movable Type Publishing Platform',
	'Movable Type Support Forum' => 'Movable Typeサポートフォーラム(英語)',
	'Movable Type System Check' => 'Movable Typeシステム・チェック',
	'Movable Type System Check Successful' => 'Movable Typeのシステム・チェックは、無事に完了しました',
	'Movable Type Technical Support' => 'Movable Typeテクニカル・サポート',
	'Movable Type User Manual' => 'Movable Typeのユーザー・マニュアル',
	'Move' => '移動',
	'Move Category' => 'カテゴリーの移動',
	'MT home directory:' => 'ホーム・ディレクトリー: ',
	'MT[_1] must be used in a category context' => 'MT[_1]は、<MTCategories>コンテナ内で使ってください。',
	'MTSubCatsRecurse used outside of MTSubCategories' => '<MTSubCatsRecurse>タグが、<MTSubCategories>コンテナの外で使われています。',
	'Multi-weblog comment listing.' => 'すべてのコメントの一覧です。',
	'Multi-weblog entry listing.' => 'すべてのエントリーの一覧です。',
	'Multi-weblog TrackBack listing.' => 'すべてのトラックバックの一覧です。',
	'My Weblogs' => 'ブログの一覧',
	'Name' => '名前',
	'Name and email address are required.' => '名前とメールアドレスの入力は必須です。',
	'Name your weblog. The weblog name can be changed at any time.' => 'ブログに名前をつけてください。名前はいつでも変更できます。',
	'Name:' => '名前: ',
	'Need a Source URL (url).' => '送信元のURLが必要です。',
	'Need a status to update entries' => 'エントリーを更新するのに状態が必要です。',
	'Need a TrackBack ID (tb_id).' => 'トラックバックIDが必要です。',
	'Need either ImportAs or ParentAuthor' => '「ImportAs」か「ParentAuthor」が必要です。',
	'Need entries to update status' => '状態を更新するのにエントリーが必要です。',
	'New Comment Posted to \'[_1]\'' => '「[_1]」に投稿された新しいコメント',
	'New Entry' => '新規エントリー',
	'New Entry Default Settings' => '新規投稿の設定',
	'New Entry Defaults' => '新規投稿',
	'New Password:' => '新しいパスワード: ',
	'New Template' => '新規テンプレート',
	'New TrackBack Ping to Category [_1] ([_2])' => 'カテゴリー「[_1] ([_2])」への新しいトラックバックです',
	'New TrackBack Ping to Entry [_1] ([_2])' => 'エントリー「[_1] ([_2])」への新しいトラックバックです',
	'New Weblog' => '新規ブログ',
	'New Weblog Settings' => 'ブログの新規作成',
	'Newer' => '前へ',
	'Next' => '次へ',
	'No' => 'いいえ',
	'No actions' => '操作なし',
	'No alternate template is specified for the Template \'[_1]\'' => '代替のテンプレートが指定されていません: [_1]',
	'No archive templates could be found.' => 'アーカイブ・テンプレートは見つかりません。',
	'No Archives' => 'アーカイブはありません',
	'No Blog' => 'ブログが見つかりません。',
	'No blog ID' => 'ブログIDがありません',
	'No blog_id' => 'ブログID見つかりません。',
	'No categories with the same name can have the same parent' => '同一名のサブ・カテゴリーは設定できません',
	'No commenters could be found.' => 'コメント投稿者は見つかりません。',
	'No commenters were found that match the given criteria.' => '該当するコメント投稿者は見つかりません。',
	'No comments appeared to be junk.' => 'どのコメントも迷惑コメントではないようです。',
	'No comments could be found.' => 'コメントは見つかりません。',
	'No comments exist for this entry.' => 'このエントリーにコメントはありません。',
	'No comments were found that match the given criteria.' => '該当するコメントは見つかりません。',
	'No email address for author \'[_1]\'' => '投稿者「[_1]」にはメールアドレスが設定されていません',
	'No entries could be found.' => 'エントリーは見つかりません。',
	'No entries were found that match the given criteria.' => '該当するエントリーは見つかりません。',
	'No entry ID provided' => '指定したエントリーIDのエントリーが見つかりません。',
	'No entry was specified; perhaps there is a template problem?' => 'エントリーが見つかりません。テンプレートに問題がある可能性があります。',
	'No entry_id' => 'エントリーIDが見つかりません。',
	'No Excerpt' => '概要がありません',
	'No executable code' => 'テキスト・フォーマッティングでエラーが発生しました。',
	'No id' => 'IDが見つかりません。',
	'No index templates could be found.' => 'インデックス・テンプレートが見つかりません。',
	'No junk comments could be found.' => '迷惑コメントは見つかりません。',
	'No junk TrackBacks could be found.' => '迷惑トラックバックは見つかりません。',
	'No label' => 'カテゴリーが見つかりません。',
	'No log entries could be found.' => 'ログ・エントリーは見つかりません。',
	'No log messages were found that match the given criteria.' => '該当するログは見つかりません。',
	'No MTPingURL defined in mt.cfg' => '「MTPingURL」が、環境設定ファイルに設定されていません。',
	'No Name' => '名前がありません',
	'No new comments were found in the specified interval.' => '指定された期間にコメントは見つかりません。',
	'No notifications could be found.' => '通知先はありません。',
	'No one' => 'なし',
	'No pages were found containing' => '含んだページは見つかりません。',
	'No permissions' => '権限がありません',
	'No permissions. Please contact your administrator for upgrading Movable Type.' => '権限がありません。管理者に連絡し、Movable Typeをアップグレードしてください。',
	'No plugins with weblog-level configuration settings are installed.' => 'ブログ別に設定するプラグインは見つかりません。',
	'No public key could be found to validate registration.' => '公開鍵が取得できません。',
	'No readable files could be found in your import directory [_1].' => '読み込み元ディレクトリー[_1]に、読み込み可能なファイルはありません。',
	'No results found' => '見つかりません。',
	'No site' => '許可しない',
	'No Stream' => 'ファイルが開けません。',
	'No such author \'[_1]\'' => '「[_1]」という投稿者は存在しません',
	'No such blog [_1]' => '「[_1]」というブログはありません',
	'No such category \'[_1]\'' => '「[_1]」というカテゴリーはありません',
	'No such comment' => 'コメントが見つかりません。',
	'No such commenter [_1].' => '「[_1]」というコメント投稿者は存在しません',
	'No such config variable \'[_1]\'' => '「[_1]」という設定変数はありません',
	'No such entry \'[_1]\'' => '「[_1]」というエントリーはありません',
	'No such entry \'[_1]\'.' => '「[_1]」というエントリーはありません',
	'No such entry ID \'[_1]\'' => '指定したエントリーID[_1]のエントリーが見つかりません',
	'No such entry.' => 'エントリーが見つかりません。',
	'No such object.' => 'オブジェクトが見つかりません。',
	'No template modules could be found.' => 'テンプレート・モジュールは見つかりません。',
	'No templates were found that match the given criteria.' => '該当するテンプレートは見つかりません。',
	'No Title' => 'タイトルがありません',
	'No title' => 'タイトルがありません',
	'No TrackBacks appeared to be junk.' => 'どのトラックバックも迷惑トラックバックではないようです。',
	'No TrackBacks could be found.' => 'トラックバックは見つかりません。',
	'No TrackBacks exist for this entry.' => 'このエントリーにはトラックバックはありません。',
	'No TrackBacks were found that match the given criteria.' => '該当するトラックバックは見つかりません。',
	'No weblogs could be found.' => 'ブログが見つかりません。',
	'No WeblogsPingURL defined in mt.cfg' => '「WeblogsPingURL」が、環境設定ファイルに設定されていません。',
	'None' => 'なし',
	'None given' => '未公開',
	'Norwegian' => 'ノルウェー語',
	'Not allowed to view blog [_1]' => 'ブログへのアクセス許可がありません: [_1]',
	'Not Junk' => '解除',
	'Note: Commenting is currently disabled at the system level.' => '注: システム全体で、コメントを受け付けない設定になっており、この設定は有効でありません。',
	'Note: If you chose to send the weblog entry, all added HTML will be included in the email.' => '注: エントリーの本文を送ると、中に書かれているHTMLコードも一緒に送信されてしまいます。',
	'Note: The above option is currently ignored since outbound pings are disabled system-wide.' => '注: システム全体で、トラックバックを送信しない設定になっており、この設定は有効でありません。',
	'Note: The above option may be affected since outbound pings are constrained system-wide.' => '注: システム全体で、トラックバックの送信先を制限しており、影響を受ける場合があります。',
	'Note: This option is currently ignored since comments are disabled either weblog or system-wide.' => '注: このブログまたはシステム全体で、コメントを受け付けない設定になっており、この設定は有効でありません。',
	'Note: This option is currently ignored since outbound pings are disabled system-wide.' => '注: システム全体で、トラックバックを送信しない設定になっており、この設定は有効でありません。',
	'Note: This option is currently ignored since TrackBacks are disabled either weblog or system-wide.' => '注: 本ブログまたはシステム全体で、トラックバックを受け付けない設定になっており、この設定は有効でありません。',
	'Note: TrackBacks are currently disabled at the system level.' => '注: システム全体で、トラックバックを受け付けない設定になっており、この設定は有効でありません。',
	'Note: You have selected to accept comments from authenticated commenters only but authentication is not enabled. In order to receive authenticated comments, you must enable authentication.' => '注: 認証されたコメント投稿者からのコメントのみを受け付ける設定になっていますが、認証に関する設定を完了していません。認証に関する設定を完了してください。',
	'Notification' => '通知',
	'notification address' => '通知先アドレス',
	'notification addresses' => '通知先アドレス',
	'Notification List' => '通知リスト',
	'Notifications' => '通知',
	'Notify the following sites upon weblog updates:' => '更新を自動通知する先: ',
	'Now you can comment.' => 'さん。コメントしてください。',
	'of' => '/',
	'Off' => '設定しない',
	'ok (ID [_1])\n' => '完了しました。(ID: [_1])',
	'ok\n' => '設定ができました。',
	'Older' => '次へ',
	'On' => '設定する',
	'on this weblog' => 'このブログ',
	'one month back' => '1か月前',
	'One of the entries ([_1]) did not actually exist' => 'エントリー「[_1])」が見つかりません。',
	'One or more errors occurred when sending update pings or TrackBacks.' => 'トラックバックか、アップデート情報の送信でエラーがありました。',
	'one week back' => '1週間前',
	'one year back' => '1年前',
	'only' => '該当する',
	'Only show banned commenters' => '禁止のコメント投稿者を表示する',
	'Only show future entries' => '指定日公開のエントリーを表示する',
	'Only show neutral commenters' => '認証サービスで認証されたコメント投稿者のみを表示する',
	'Only show pending comments' => '保留のコメントを表示する',
	'Only show pending TrackBacks' => '保留のトラックバックを表示する',
	'Only show published comments' => '公開のコメントを表示する',
	'Only show published entries' => '公開のエントリーを表示する',
	'Only show published TrackBacks' => '公開のトラックバックを表示する',
	'Only show trusted commenters' => '登録済みのコメント投稿者を表示する',
	'Only show unpublished entries' => '未公開 (下書き) のエントリーを表示する',
	'Only the sites on the following domains:' => '以下のドメインへのトラックバックを許可する: ',
	'Only the weblogs on this installation' => 'このシステムのブログへのトラックバックを許可する',
	'Only when attention is required' => '公開に承認を必要とするもののみ',
	'Open power-editing mode' => '一括編集モード',
	'Opening linked file \'[_1]\' failed: [_2]' => 'リンクされたファイル[_1]が開けません: [_2]',
	'Opening local file \'[_1]\' failed: [_2]' => 'ローカル・ファイル[_1]が開けません: [_2]',
	'Operating system:' => 'オペレーティング・システム（OS）: ',
	'Optional' => 'オプション',
	'Or, manually enter token:' => 'または、認証用トークンを入力します: ',
	'Order:' => '表示順序',
	'Orphaned comment' => 'コメントに関するエントリーがありません',
	'Orphaned TrackBack' => 'トラックバックに関するエントリーがありません',
	'Others:' => 'その他: ',
	'Outbound TrackBack Control' => 'トラックバックの送信',
	'Outbound TrackBack URLs' => 'トラックバック送信先のURL',
	'Outbound TrackBacks' => 'トラックバックの送信',
	'Output File' => '出力ファイル名',
	'Output Filename' => '出力ファイル名',
	'Page Not Found' => 'ページが見つかりません。',
	'Parameter \'[_1]\' is required' => '次のパラメーターが必要です: [_1]',
	'Parent Category:' => '親のカテゴリー: ',
	'Parse error in template \'[_1]\': [_2]' => 'テンプレート「[_1]」に解析エラーが発生しました: [_2]',
	'Parse error: [_1]' => '解析エラー: [_1]',
	'Passphrase Protection (Optional)' => 'パスワード保護 (オプション)',
	'Password' => 'パスワード',
	'Password (required if creating new authors):' => '初期パスワード (新しい投稿者のパスワード):',
	'Password Confirm:' => '変更の確認: ',
	'Password hint (*):' => 'パスワード・ヒント (*): ',
	'Password hint is required.' => 'パスワード・ヒントを入力してください。',
	'Password hint:' => 'パスワード・ヒント: ',
	'Password Recovery' => 'パスワード再取得の設定',
	'Password was reset for author \'[_1]\' (user #[_2])' => '「[_1] (ID: [_2])」のパスワードを初期化しました。',
	'Passwords do not match.' => '入力したパスワードが一致しません。',
	'Pending' => '保留',
	'Pending Approval' => '保留',
	'Percent' => 'パーセント',
	'Perl include path:' => 'Perl Include ライブラリ・パス: ',
	'Perl module Image::Size is required to determine width and height of uploaded images.' => '「Image::Size」は、画像のサイズを調べるために必要です。',
	'Perl version:' => 'Perl のバージョン: ',
	'Permalink' => 'パーマリンク',
	'Permission denied.' => '権限がありません。',
	'Permission denied. ' => '権限がありません。',
	'Permissions' => '権限',
	'personal OR publishing' => '検索条件1 OR 検索条件2',
	'Ping \'[_1]\' failed: [_2]' => '「[_1]」へのトラックバックは失敗しました: [_2]',
	'Ping error: [_1]' => 'トラックバック・エラー: [_1]',
	'Pinging sites...' => 'トラックバック/更新中...',
	'pings' => 'トラックバック',
	'Pixels' => 'ピクセル',
	'Please click the Save Changes button below to disable authentication.' => '認証サービスを利用しない場合は、下にある「変更を保存」ボタンをクリックしてください。',
	'Please click the Save Changes button below to enable authentication.' => '認証サービスを利用する場合は、下にある「変更を保存」ボタンをクリックしてください。',
	'Please consult the installation instructions for help in installing [_1].' => '「[_1]」をインストールする場合は、インストール手順を参照してください。',
	'Please enter a valid email address.' => 'メールアドレスを正しく入力してください。',
	'Please verify your email to subscribe' => 'メールアドレスの登録を確認してください',
	'Plugin Actions' => 'ブラグイン',
	'Plugin Directory' => 'プラグイン・ディレクトリー',
	'Plugin error:' => 'プラグイン・エラー: ',
	'Plugin error: [_1] [_2]' => 'プラグイン「[_1]」でエラーが発生しました: [_2]',
	'Plugin Home' => 'プラグイン・ホーム',
	'Plugin Set: [_1]' => 'プラグイン: [_1]',
	'Plugin Settings' => 'プラグインの設定',
	'Plugins' => 'プラグイン',
	'Polish' => 'ポーランド語',
	'Populating blog with default templates failed: [_1]' => 'デフォルト・テンプレートの設定に失敗しました: [_1]',
	'Popup Image' => 'ポップアップ',
	'Portuguese' => 'ポルトガル語',
	'Post' => '投稿',
	'Post a comment' => 'コメントを投稿',
	'Post Comments' => 'コメントの投稿',
	'Post Status' => '公開設定',
	'Posted by' => '投稿者: ',
	'Posted by [_1] at [_2]' => '投稿者: [_1] 日時: [_2]',
	'Posted by [_1] on [_2]' => '投稿者: [_1] 日時: [_2]',
	'Posted by:' => '投稿者: ',
	'Posted in' => '投稿: ',
	'Posted in ' => '投稿: ',
	'Posting' => '投稿',
	'Preferences' => '設定',
	'Preferred' => '優先',
	'Preferred Archive Type:' => 'パーマリンクの設定: ',
	'Prepare failed' => 'オブジェクト・ドライバーでエラーが発生しました。',
	'PreSave failed [_1]' => '「PreSave」でエラーが発生しました: [_1]',
	'Preview' => '確認',
	'Preview this entry (p)' => '確認 (P)',
	'Previewing your Comment' => 'コメントの確認',
	'Previous' => '前へ',
	'Primary Category' => 'メイン・カテゴリー',
	'Professional Network' => 'ProNet (英語)',
	'Profile' => 'プロフィール',
	'Publicity/Remote Interfaces' => '更新Ping/トラックバックの設定',
	'Publish' => '公開',
	'Publish archives to alternate root path' => 'アーカイブを、サイト・パスとは別のパスで公開する場合は、チェックしてください。',
	'Publish Entries' => '公開する',
	'Publish selected comments (p)' => '選択したコメントを公開 (P)',
	'Publish selected TrackBacks (p)' => '選択したトラックバックを公開 (P)',
	'Published' => '公開',
	'published' => '公開',
	'Publishing' => '公開',
	'publishing NOT personal' => '検索条件1 NOT 検索条件2',
	'Publishing Paths' => 'サイトURL/パス',
	'Publishing Preferences' => '公開',
	'Publishing Settings' => '公開の設定',
	'Quickfilter:' => '',
	'QuickPost' => 'クイック投稿',
	'Quote' => '引用',
	'Read More' => '詳しくはこちら',
	'Read more.' => '詳しくはこちら。',
	'Reading \'[_1]\' failed: [_2]' => '[_1]の読み込みに失敗しました。',
	'Reading file \'[_1]\' failed: [_2]' => 'ファイル[_1]の読み込みに失敗しました: [_2]',
	'Reading image failed: [_1]' => '画像の読み込みに失敗しました: [_1]',
	'Rebuild' => '再構築',
	'Rebuild (r)' => '再構築 (R)',
	'Rebuild [_1] Archives Only' => 'アーカイブのみを再構築: [_1]',
	'Rebuild Again' => 'もう一度再構築する',
	'Rebuild All Files' => 'すべてを再構築',
	'Rebuild failed: [_1]' => '再構築に失敗しました: [_1]',
	'Rebuild Files' => '再構築',
	'Rebuild indexes' => 'インデックス・テンプレートを再構築',
	'Rebuild Indexes Only' => 'インデックス・テンプレートを再構築',
	'Rebuild my site' => 'サイトを再構築',
	'Rebuild selected entries (r)' => '再構築 (R)',
	'Rebuild Site' => 'サイトを再構築',
	'Rebuild this template' => 'このテンプレートを再構築',
	'Rebuild this template automatically when rebuilding index templates' => 'インデックス・テンプレートを再構築するときに、このテンプレートを自動的に再構築する',
	'Rebuilding [_1]' => '再構築中 [_1]',
	'Rebuilding [_1] dynamic links' => '再構築中 [_1]',
	'Rebuilding [_1] pages' => '再構築中 [_1]',
	'Rebuilding [_1] pages [_2]' => '再構築中 [_1]: [_2]',
	'Rebuild-option name must not contain special characters' => '再構築のオプションに、特殊文字が含まれています。',
	'Recent Posts' => '最近のエントリー',
	'Recently Updated Key:' => 'Recently Updatedキー: ',
	'Recover' => 'パスワードを再設定',
	'Recover selected comments (j)' => '迷惑コメントを解除します (J)',
	'Recover selected TrackBacks (j)' => '迷惑トラックバックを解除します (J)',
	'Re-Edit this entry' => '編集画面に戻る',
	'Refresh Template(s)' => 'テンプレートを更新する',
	'Regex Match' => '正規表現',
	'Regex search' => '正規表現で検索',
	'Registered Commenter' => '登録しているコメント投稿者',
	'Registered Plugins' => '登録済みプラグイン',
	'Registration is required.' => 'コメントを行うためには登録が必要です。',
	'Relative' => '経過時間',
	'Remember me?' => 'ログイン情報を記憶しますか?',
	'Remember personal info?' => 'この情報を登録しますか?',
	'Remove failed on SQL error [_1]' => 'SQLエラーが発生しました: [_1]',
	'Remove this license' => 'このライセンスを取り除く',
	'Remove-all failed on SQL error [_1]' => 'SQLエラーが発生しました: [_1]',
	'Removing placement failed: [_1]' => 'エントリーとブログの関連づけの削除に失敗しました: [_1]',
	'Renaming \'[_1]\' to \'[_2]\' failed: [_3]' => '[_1]&quotl;を[_2]に名称を変更できません: [_3]',
	'Renaming tempfile \'[_1]\' failed: [_2]' => 'テンポラリーファイル[_1]のファイル名の変更に失敗しました: [_2]',
	'Repeat the password for confirmation.' => '確認のために、パスワードを再度入力してください。',
	'Replace Checked' => '選択したものを対象に置換',
	'Replace:' => '置換: ',
	'Replaced [_1] records successfully.' => '[_1]件の置換に成功しました。',
	'Require E-mail Address' => 'メールアドレスの要求',
	'Required' => '必要',
	'Reset' => 'リセット',
	'Reset Activity Log' => 'ログの消去',
	'Reset to Defaults' => '初期化',
	'Resources' => 'リソース',
	'Resources Provided by [_1]' => '「[_1]」について',
	'Results' => '結果',
	'Return to comment list' => 'コメントの一覧に戻る',
	'Return to Movable Type' => 'Movable Typeに戻る',
	'Return to the original entry' => 'エントリーのページに戻る',
	'Reveal' => '内容を表示',
	'Running [_1]' => '実行中: [_1]',
	'Save' => '保存',
	'Save and Rebuild' => '保存と再構築',
	'Save and rebuild this template (r)' => 'テンプレートの保存と再構築 (R)',
	'Save Changes' => '変更を保存',
	'Save changes (s)' => '変更を保存 (S)',
	'Save failed: [_1]' => '保存に失敗しました: [_1]',
	'Save permissions for this author (s)' => 'この投稿者の権限を保存 (S)',
	'Save these entries (s)' => 'エントリーを保存 (S)',
	'Save this author (s)' => '投稿者の情報を保存する',
	'Save this comment (s)' => 'コメントを保存 (S)',
	'Save this entry' => 'このエントリーを保存する',
	'Save this entry (s)' => 'エントリーを保存 (S)',
	'Save this template (s)' => 'テンプレートを保存 (S)',
	'Save this TrackBack (s)' => 'トラックバックを保存 (S)',
	'Saving author failed: [_1]' => '投稿者の保存に失敗しました: [_1]',
	'Saving blog failed: [_1]' => 'ブログの保存に失敗しました: [_1]',
	'Saving category failed: [_1]' => 'カテゴリーの保存に失敗しました: [_1]',
	'Saving comment failed: [_1]' => 'コメントの保存に失敗しました: [_1]',
	'Saving entry (\'[_1]\')... ' => 'エントリー 「[_1]」を保存します。',
	'Saving entry \'[_1]\' failed: [_2]' => 'エントリー「[_1]」の保存に失敗しました: [_2]',
	'Saving entry failed: [_1]' => 'エントリーの保存に失敗しました: [_1]',
	'Saving map failed: [_1]' => 'マップの保存に失敗しました: [_1]',
	'Saving object failed: [_1]' => 'オブジェクトの保存に失敗しました: [_1]',
	'Saving object failed: [_2]' => 'オブジェクトの保存に失敗しました: [_1]',
	'Saving permission failed: [_1]' => '権限の保存に失敗しました: [_1]',
	'Saving permissions failed: [_1]' => '権限の保存に失敗しました: [_1]',
	'Saving ping failed: [_1]' => 'トラックバックの保存に失敗しました: [_1]',
	'Saving placement failed: [_1]' => 'エントリーとブログの関連づけができません: [_1]',
	'Scaling to [_1]x[_2] failed: [_3]' => '[_1]x[_2]へのサイズ調整に失敗しました: [_3]',
	'scheduled' => '指定日',
	'Scheduled' => '指定日',
	'Score' => 'スコア',
	'Search' => '検索',
	'Search & Replace' => '検索・置換',
	'Search &amp; Replace' => '検索・置換',
	'Search (f)' => '検索 (F)',
	'Search Again' => '再検索',
	'Search failed: [_1]' => '検索に失敗しました: [_1]',
	'Search Fields:' => '検索対象の項目: ',
	'Search for all comments from this IP address' => 'このIPアドレスから投稿されたコメントを検索',
	'Search for comments by this commenter' => 'このコメント投稿者からのコメントを検索',
	'Search for new comments from:' => '新しいコメントから検索: ',
	'Search for other TrackBacks from this site' => 'このサイトからの別のトラックバックを検索',
	'Search for other TrackBacks with this status' => '同じ状態のトラックバックを検索',
	'Search for other TrackBacks with this title' => '同じタイトルのトラックバックを検索',
	'Search Results' => '検索結果',
	'Search Results from' => '検索結果',
	'Search this blog:' => 'ブログを検索: ',
	'Search this site:' => 'サイトを検索: ',
	'Search:' => '検索: ',
	'Search: new comment search' => 'コメントの検索',
	'Search: query for \'[_1]\'' => '「[_1]」を検索',
	'Searched for' => '検索',
	'Secondary categories:' => 'サブカテゴリー: ',
	'Select' => '選択',
	'Select a category' => 'カテゴリーを選ぶ',
	'Select a Creative Commons license for the posts on your blog (optional).' => 'エントリーのクリエイティブ・コモンズ・ライセンスを選んでください 。(オプション)',
	'Select a password for the author.' => '新しいパスワードを入力してください。',
	'Select a post status' => '公開設定を選ぶ',
	'Select a weblog' => 'ブログを選択',
	'Select a weblog for this post:' => '投稿先のブログ: ',
	'Select an entry to send an outbound TrackBack:' => 'トラックバックの発信元になるエントリーを選択: ',
	'Select the language in which you would like dates on your blog displayed.' => 'ブログに表示する日付の言語を選んでください。',
	'Select the number of days\' entries or the exact number of entries you would like displayed on your weblog.' => 'ブログのメインページに表示されるエントリーについて設定します。',
	'Select the time interval that you\'d like to search in, then click \'Find new comments\'' => '検索したい期間を選択して、コメントを検索をクリックしてください。',
	'Select the type of rebuild you would like to perform. (Click the Cancel button if you do not want to rebuild any files.)' => '再構築する対象を選んでください。再構築を行わない場合は、「取り消し」ボタンを押してください。',
	'Select this option only if you need to publish your archives outside of your Site Root.' => 'アーカイブをサイト・パスとは別のパスで公開する場合に選択してください。',
	'Select whether you want visitor comments displayed in ascending (oldest at top) or descending (newest at top) order.' => 'コメントの表示順を、古いもの順か新しいもの順か選んでください。',
	'Select whether you want your posts displayed in ascending (oldest at top) or descending (newest at top) order.' => 'エントリーを表示する順番を設定してください。昇順 (古いものを一番上にして時系列に並べる) か、降順 (最新のエントリーが常に上に来るように逆順で並べるか) か選んでください。',
	'Select your timezone from the pulldown menu.' => '時間帯を選んでください。',
	'Send' => '送信',
	'Send a Notification' => 'お知らせを送る',
	'Send an outbound TrackBack:' => 'トラックバックを送る: ',
	'Send Notifications' => 'お知らせの送信',
	'Sending mail via SMTP requires that your server have Mail::Sendmail installed: [_1]' => 'SMTPでメールを送信するには、サーバーにMail::Sendmailをインストールする必要があります: [_1]',
	'Server status and information.' => 'サーバーの状態と情報。',
	'Set each template\'s Build Options separately' => 'テンプレート別に、スタティックHTMLもしくはダイナミック・パブリッシングを選択します',
	'Set Up A QuickPost Bookmarklet' => 'クイック投稿の設定',
	'Setting blog allow pings status...' => 'データベースをアップグレードします: トラックバック関連の設定',
	'Setting blog basename limits...' => 'データベースをアップグレードします: エントリー・ファイル名の最大長',
	'Setting default blog file extension...' => 'データベースをアップグレードします: ファイル拡張子の設定',
	'Setting Ignored' => '設定は無視されます',
	'Setting Notice' => '注: ',
	'Setting up mappings failed: [_1]' => 'テンプレート・マッピングの設定に失敗しました: [_1]',
	'Setting your permissions to administrator.' => 'データベースをアップグレードします: システム管理者の権限',
	'Settings' => '設定',
	'Settings for [_1]' => '「[_1]」の設定',
	'Setup Authentication' => '認証サービスの設定',
	'Show' => '表示:',
	'Show Activity Log' => 'ログの閲覧',
	'Show all comments on this entry' => 'このエントリーに関するコメントのみ表示',
	'Show all matches' => 'すべての結果を表示',
	'Show Display Options' => '画面の表示設定を変更',
	'Show me the HTML' => 'HTMLを表示',
	'Show pending TrackBacks' => '保留中のトラックバックのみ表示',
	'Show Resources' => 'プラグインについて',
	'Show Settings' => '設定を表示',
	'Show unpublished comments.' => '未公開のコメントを表示する',
	'Show unpublished entries.' => '未公開 (下書き) のエントリーを表示する',
	'Show unpublished TrackBacks.' => '未公開のトラックバックを表示する',
	'Show:' => '表示件数: ',
	'Showing all commenters.' => 'すべて (条件を変更する)',
	'Showing all comments.' => 'すべて (条件を変更する)',
	'Showing all entries.' => 'すべて (条件を変更する)',
	'Showing all TrackBacks.' => 'すべて (条件を変更する)',
	'Showing first [_1] results.' => '最初の「[_1]」の結果を表示。',
	'Showing only commenters whose [_1] is [_2].' => '[_1]が[_2] (条件を変更する)',
	'Showing only comments where [_1] is [_2].' => '[_1]が[_2] (条件を変更する)',
	'Showing only entries where [_1] is [_2].' => '[_1]が[_2] (条件を変更する)',
	'Showing only TrackBacks where [_1] is [_2].' => '[_1]が[_2] (条件を変更する)',
	'Showing:' => '表示件数: ',
	'sign in' => 'サインイン',
	'Sign in' => 'サインイン',
	'Sign in requires a secure signature; logout requires the logout=1 parameter' => '署名が正しくありません。ログアウトのときは「logout=1」のパラメータが必要です。',
	'sign out' => 'サイン・アウト',
	'Site JavaScript' => 'JavaScript',
	'Site Root:' => 'サイト・パス: ',
	'Site root:' => 'サイト・パス: ',
	'Site URL must be an absolute URL.' => 'サイトURLには、絶対URLを入力してください。',
	'Site URL:' => 'サイトURL: ',
	'Six Apart Plugin Directory' => 'Six Apartのプラグイン・ディレクトリーをチェックしてください。',
	'six months back' => '6か月前',
	'Slovak' => 'スロヴァキア語',
	'Slovenian' => 'スロヴェニア語',
	'SOAP::Lite is optional; It is needed if you wish to use the MT XML-RPC server implementation.' => '「SOAP::Lite」は、XML-RPC APIやAtom API を利用するときに必要です。',
	'Some entries failed to save' => '保存できなかったエントリーがあります。',
	'Some of the following modules are required by the various data storage options in Movable Type. In order run the system, your server needs to have either DB_File, or else DBI and at least one of the other modules installed.' => '以下のモジュールはMovable Typeのデータの保管、管理のために利用します。Movable Typeを利用するためには、以下のモジュールのうち少なくとも一つはインストールされている必要があります。',
	'Somehow, the entry you tried to comment on does not exist' => 'コメントしようとしたエントリーが見つかりません。',
	'Sort By:' => '並べ替え',
	'Source Site:' => 'サイト: ',
	'Source Title:' => 'タイトル: ',
	'Source URL' => 'URL',
	'Spanish' => 'スペイン語',
	'Specifies the default Accept Comments setting when creating a new entry.' => 'コメントを受け付ける場合はチェックしてください。',
	'Specifies the default Accept TrackBacks setting when creating a new entry.' => 'トラックバックを受け付ける場合はチェックしてください。',
	'Specifies the default length of an auto-generated basename. The range for this setting is 15 to 250.' => '自動生成するエントリーのファイル名の長さ (最大長) を入力してください。15～250の数値を指定できます。',
	'Specifies the default Post Status when creating a new entry.' => '新規に投稿した際の初期値を選んでください。',
	'Specifies the default Text Formatting option when creating a new entry.' => '投稿内容の改行の変換に関する初期値を選んでください。',
	'Specifies the list of HTML tags allowed by default when cleaning an HTML string (a comment, for example).' => 'HTMLタグを (コメントなどで) 取り除くとき、許可するHTMLタグを指定します。',
	'Specifies the Text Formatting option to use for formatting visitor comments.' => 'コメントの内容の改行の変換に関する初期値を選んでください。 ',
	'Specify from whom Movable Type shall accept comments on this weblog.' => '誰からのコメントを受け付けるか、条件を選んでください。',
	'Specify what should happen to non-junk comments after submission.' => '受け付けたコメントを即時に公開する条件を選んでください。',
	'Specify when Movable Type should notify you of new comments if at all.' => 'コメントを受け付けたときに、その旨をメールで通知する条件を選んでください。',
	'Specify when Movable Type should notify you of new TrackBacks if at all.' => 'トラックバックを受け付けたときに、その旨をメールで通知する条件を選んでください。',
	'Start title HTML (optional):' => '最初のタイトルHTML (オプション): ',
	'Starting installation...' => 'インストールを開始します...',
	'Starting upgrade...' => 'アップグレードを開始します...',
	'Status' => '公開の状態',
	'status' => '公開の状態',
	'Status &amp; Info' => '状態と情報',
	'Status:' => '状態:  ',
	'Stop accepting comments on all weblogs' => 'すべてのブログでコメントを受け付けない',
	'Stop accepting TrackBacks on all weblogs' => 'すべてのブログでトラックバックを受け付けない',
	'Storable is optional; it is required by certain MT plugins available from third parties.' => '「Storable」は、プラグイン・モジュールを実行するために必要になることがあります。',
	'Subscribe to this blog\'s feed' => 'このブログのフィードを取得',
	'Suomi' => 'フィンランド語',
	'Support' => 'サポート',
	'Support and Documentation' => 'サポート ホームページ',
	'Swedish' => 'スウェーデン語',
	'System' => 'システム',
	'System Administrator' => 'システム管理者',
	'System Information' => 'Movable Typeシステム・チェック',
	'System Information:' => 'システム情報: ',
	'System Overview' => 'システム・メニュー',
	'System Shortcuts' => 'システム・メニュー',
	'System Stats' => 'システムの状況',
	'System Status and Information' => 'システムの状態',
	'System Templates' => 'システム・テンプレート',
	'System templates specify the layout and style of a small number of dynamic pages which perform specific system functions in Movable Type.' => 'Movable Typeの一部のシステム機能はダイナミック・ページで実行しますが、システム・テンプレートはそのダイナミック・ページのレイアウトとスタイルを指定します。',
	'System-wide' => 'システム全体',
	'System-wide configuration.' => 'システム全体を設定します。',
	'System-wide listing' => 'システム全体での一覧',
	'Tag Attributes' => 'タグ属性',
	'Tags' => 'タグ',
	'Target' => '対象',
	'Target Category:' => 'カテゴリー: ',
	'Target Entry:' => 'エントリー: ',
	'Template' => 'テンプレート',
	'Template \'[_1]\' does not have an Output File.' => 'テンプレート「[_1]」の出力ファイルが設定されていません。',
	'Template Body' => 'テンプレートの内容',
	'Template Modules' => 'テンプレート・モジュール',
	'Template modules are mini-templates that produce nothing on their own but instead can be included into other templates.  They are excellent for duplicated content (e.g. header or footer content) and can contain template tags or just static text.' => 'テンプレート・モジュールは、他のテンプレートに挿入して使うモジュールです。ヘッダーやフッターといった共通部分をモジュール化することで、効率よくテンプレートを作成できます。',
	'Template Name' => 'テンプレート名',
	'Template:' => 'テンプレート: ',
	'Templates' => 'テンプレート',
	'templates' => 'テンプレート',
	'Test' => 'テスト',
	'Text' => 'テキスト',
	'Text Filters' => 'テキスト・フィルター',
	'Text Formatting' => '改行設定',
	'Thank you for commenting.' => 'コメントを受け付けました。',
	'Thanks for signing in,' => 'サインインを受け付けました。',
	'Thanks for subscribing to notifications about updates to [_1]. Follow the link below to confirm your subscription:' => '登録してくれてありがとう。ブログ「[_1]」の更新通知への登録は、以下の URL にアクセスすると完了します: ',
	'That action ([_1]) is apparently not implemented!' => 'この操作 ([_1]) は、現在実装されていません。',
	'The activity log has been reset.' => 'ログを消去しました。',
	'The address [_1] has been unsubscribed.' => 'メールアドレス[_1]の登録を解除しました。',
	'The address [_1] was not subscribed.' => 'メールアドレス[_1]は登録されていません。',
	'The approval could not be committed: [_1]' => '権限の保存に失敗しました: [_1]',
	'The author\'s email address.' => 'この投稿者のメールアドレスです。',
	'The author\'s preferred language.' => 'この投稿者が、選択した表示用の言語です。',
	'The author\'s published name.' => 'この投稿者の投稿が、公開される際に表示される名称です。',
	'the beginning' => '開始時点から',
	'The category must be given a name!' => 'カテゴリーの名称を設定してください。',
	'The comment has been approved.' => 'コメントを承諾しました。',
	'The commenter has been banned.' => 'コメント投稿者は禁止されています。',
	'The commenter has been trusted.' => 'コメント投稿者は登録済みです。',
	'The DBD::mysql version you have installed is known to be incompatible with Movable Type. Please install the current release available from CPAN.' => 'インストールされている「DBD:mysql」ではご利用できません。最新のバージョンをご利用ください。',
	'The email address \'[_1]\' is already in the notification list for this weblog.' => 'メールアドレス[_1]はすでに登録されています。',
	'The e-mail address you entered is already on the Notification List for this weblog.' => 'メールアドレスはすでに通知リストに登録されています。',
	'The file you uploaded is too large.' => 'アップロードしようとしたファイルのサイズが大き過ぎます。',
	'The following items may be junk. Uncheck the box next to any items are NOT junk and hit JUNK to continue.' => '迷惑コメント/トラックバックの可能性があります。迷惑コメント等の場合はチェックボックスにチェックし、そうでない場合はチェックボックスのチェックをはずしてください。',
	'The following modules are <strong>optional</strong>. If your server does not have these modules installed, you only need to install them if you require the functionality that the module provides.' => '以下のモジュールは<strong>オプション</strong>です。なくても動作しますが、関連する機能を利用するためにはインストールしておく必要があります。',
	'The IP you entered is already banned for this weblog.' => 'すでに禁止IPアドレスリストに登録されています。',
	'The login could not be confirmed because of a database error ([_1])' => 'データベースのエラーが発生し、ログインを確認できません: [_1]',
	'The Movable Type activity log contains a record of notable actions in the system.' => 'ログにはシステムの利用記録が保存されています。',
	'The name \'[_1]\' is too long!' => '「[_1]」は、指定の長さを超えています。',
	'The name used by this author to login.' => 'この投稿者が、ログインの際に入力する名称です。',
	'The search engine also supports AND, OR, and NOT keywords to specify boolean expressions:' => '以下のように検索条件を AND、OR、NOT を使って指定することもできます: ',
	'The secondary categories for this entry have been updated. You will need to SAVE the entry for these changes to be reflected on your public site.' => 'サブカテゴリーを更新しました。サイトへ変更を反映させるには、エントリーを保存してください。',
	'The selected archive-template associations have been deleted.' => '選択したテンプレートは削除されました。',
	'The selected comment(s) has been deleted from the database.' => 'コメントをデータベースから削除しました。',
	'The selected comment(s) has been junked.' => '選択したコメントを迷惑コメントに変更しました。',
	'The selected comment(s) has been published.' => '選択したコメントを公開しました。',
	'The selected comment(s) has been unjunked.' => '選択したコメントを正常なコメントに変更しました。',
	'The selected comment(s) has been unpublished.' => '選択したコメントを未公開に変更しました。',
	'The selected commenter(s) has been given trusted status.' => '選択したコメント投稿者を登録しました。',
	'The selected commenter(s) have been blocked from commenting.' => '選択したコメント投稿者は、コメントを投稿できません。',
	'The selected commenter(s) have been unbanned.' => '選択したコメント投稿者は、コメントを投稿できます。',
	'The selected TrackBack(s) has been deleted from the database.' => '選択したトラックバックは、データベースから削除されています。',
	'The selected TrackBack(s) has been junked.' => '選択したトラックバックを迷惑トラックバックに変更しました。',
	'The selected TrackBack(s) has been published.' => '選択したトラックバックを公開しました。',
	'The selected TrackBack(s) has been unjunked.' => '選択したトラックバックを正常なトラックバックに変更しました。',
	'The selected TrackBack(s) has been unpublished.' => '選択したトラックバックを未公開に変更しました。',
	'The sign-in attempt was not successful; please try again.' => 'サインインに失敗しました。もう一度試してください。',
	'The sign-in validation failed.' => 'サインインに失敗しました。',
	'The sign-in validation was not successful. Please make sure your weblog is properly configured and try again.' => 'サインインに失敗しました。ブログの設定を確認してから試してください。',
	'The TrackBack has been approved.' => 'トラックバックは承認されました。',
	'The URL of this author\'s website. (Optional)' => 'この投稿者のウェブサイトのURLです（オプション）。',
	'The value you entered was not a valid email address' => '送信可能なメールアドレスを入力してください。',
	'There is already a weblog by that name!' => 'すでに使われています。',
	'These domain names were found in the selected comments. Check the box at right to block comments and trackbacks containing that URL in the future.' => 'これらのドメイン名は、選択したコメントにありました。今後、そのURLを含むコメントやトラックバックをブロックするには、右側のチェックボックスをオンにしてください。',
	'Third-Party Services' => '他のサービスの設定',
	'This advanced feature allows you to map any archive template to multiple archive types. For example, you may want to create two different views of your monthly archives: one in which the entries for a particular month are presented as a list, and the other representing the entries in a calendar view of that month.' => 'この画面では、各アーカイブに複数のテンプレートを設定することができます。例えば、月別のアーカイブを2つ作り、1つは1か月分のエントリーのリストにして、もう1つは、カレンダーのようにエントリーを見られるようにする、といったことができます。',
	'This feature allows you to limit outbound TrackBacks and TrackBack auto-discovery for the purposes of keeping your installation private.' => 'イントラネットでのプライベートな利用のために、トラックバックの送信や自動検知を制限する場合に設定します。',
	'This is an experimental feature; turn off SafeMode (in mt.cfg) in order to use it.' => '環境設定ファイルの「SafeMode」を設定してください。',
	'This is the URL that others will use to send TrackBacks to your weblog. If you wish for anyone to send TrackBacks to your weblog when they have a post specific to this category, post this URL publicly. If you choose to only allow a select group of individuals to TrackBack, send this URL to them privately.' => '以下の URL は、このカテゴリーのエントリーに対するトラックバックを受け付けるためのものです。',
	'This page provides you with information on your system\'s configuration and determines whether you have all of the components you need to run Movable Type.' => 'Movable Typeが動作するために必要なPerlモジュールのインストールについての確認と、設定に関するシステムの情報を表示します。',
	'This page will soon contain information about the server environment availability of required perl modules, installed plugins and other information useful for expediting debugging in technical support requests.' => 'この画面には、必要なPerlモジュールのインストール状況といったサーバー環境、インストールされたプラグイン、テクニカル・サポートを迅速に進めるために有効な情報等が表示されます。',
	'This screen allows you to ban comments and TrackBacks from specific IP addresses.' => 'この画面では、特定のIPアドレスからのコメントとトラックバックを禁止します。',
	'This screen allows you to configure feedback and outbound TrackBack settings for the entire installation.  These settings override any similar settings for individual weblogs.' => 'この画面では、システム全体にわたるコメントとトラックバックの設定ができます。これらの設定は、個々のブログの設定より優先されます。',
	'This screen allows you to control default settings for new entries as well as your publicity and remote interface settings.' => 'この画面では、新しくエントリーを投稿するときの初期値、および公開/リモート用のインターフェイスを設定できます。',
	'This screen allows you to control general weblog settings, default weblog display settings, and third-party service settings.' => 'この画面では、ブログの基本的な設定、表示に関する初期設定、および他のサービスの設定ができます。',
	'This screen allows you to control the feedback settings for this weblog, including comments and TrackBacks.' => 'この画面では、コメントやトラックバックなどの設定ができます。',
	'This screen allows you to control the weblog-level settings of any configurable plugins you\'ve installed.' => 'この画面では、このブログで利用可能なプラグインの設定ができます。',
	'This screen allows you to control this weblog\'s publishing paths and preferences, as well as archive mapping settings.' => 'この画面では、このブログのサイトのURL、公開時の設定、およびアーカイブの設定ができます。',
	'This TrackBack item is disabled.' => 'このトラックバックは利用できません。',
	'This TrackBack item is protected by a passphrase.' => 'このトラックバックはパスワードで保護されています。',
	'This weblog is licensed under a' => 'このブログは、次のライセンスで保護されています。',
	'This weblog requires commenters to pass an email address' => 'サインインしたサイトでは、コメントの投稿には、メールアドレスを通知するようにリクエストしています。',
	'This weblog requires commenters to pass an email address. If you\'d like to do so you may log in again, and give the authentication service permission to pass your email address.' => 'サインインしたサイトでは、コメントの投稿には、メールアドレスを通知するようにリクエストしています。メールアドレスを通知しない限り、コメントの投稿ができません。通知をするように設定してください。',
	'This welcome message is configurable.' => 'このメッセージは変更できます。',
	'This will override all individual weblog comment settings.' => 'この設定は、個々のブログの設定より優先されます。',
	'This will override all individual weblog TrackBack settings.' => 'この設定は、個々のブログの設定より優先されます。',
	'three months back' => '3か月前',
	'Thumbnail failed: [_1]' => 'サムネイルの作成に失敗しました: [_1]',
	'Tie \'[_1]\' failed: [_2]' => '「[_1]」を関連づけられません: [_2]',
	'Time to Upgrade!' => 'Movable Typeのアップグレード',
	'Time zone not selected' => '時間帯は選択されていません',
	'Timezone:' => '時間帯（タイムゾーン）: ',
	'Title' => 'タイトル',
	'Title:' => 'タイトル: ',
	'to act upon' => '設定',
	'To create a new category, enter a title in the field below, select a parent category, and click the Add button.' => 'カテゴリーを追加するときは、タイトルを入力した後、親カテゴリーを選択して追加を押してください。',
	'To download more plugins, check out the <a href="http://www.sixapart.com/pronet/plugins/">Six Apart Plugin Directory</a>.' => '他のプラグインを追加する場合は、<a href="http://www.sixapart.jp/movabletype/plugins/">Six Apart プラグイン・ディレクトリー</a>もご覧ください。',
	'To enable comment registration, you need to add a TypeKey token in your weblog config or author profile.' => 'コメント登録機能を使うには、TypeKeyトークンをブログ、もしくは投稿者のプロフィールで設定する必要があります。',
	'To include a list of incoming TrackBacks in your Main Index Template, check the documentation for template tags related to TrackBacks.' => '受け付けたトラックバックの一覧をメインページのテンプレートで利用したいときは、トラックバックに関連するタグのヘルプを参照してください: ',
	'to publish' => '公開',
	'to rebuild' => '再構築',
	'To return to the comment list without junking any items, click CANCEL.' => '変更を反映せずにコメントの一覧に戻るには、「取り消し」ボタンをクリックしてください。',
	'To see the changes reflected on your public site, you should rebuild your site now.' => '変更をサイトに反映するには、再構築してください。',
	'To upload a file to your server, click on the browse button to locate the file on your hard drive.' => 'ファイルをアップロードするには、「参照 (Browse)」ボタンを押して、ファイルを指定してください。',
	'to use it here.' => 'してください。',
	'To:' => '終了日: ',
	'Top and bottom of the page' => 'ページの上と下',
	'Top Level' => 'トップレベル',
	'Top of the page' => '編集画面の上',
	'TrackBack' => 'トラックバック',
	'TrackBack Auto-Discovery' => 'トラックバック自動検知',
	'TrackBack Items' => 'トラックバックする',
	'TrackBack Listing Template' => 'トラックバックの一覧',
	'Trackback pings must use HTTP POST' => 'トラックバックの送信は、HTTP POSTメソッドを使う必要があります。',
	'TrackBack Settings' => 'カテゴリーのトラックバック設定',
	'TrackBack URL for this category' => 'このカテゴリーのトラックバックURL',
	'TrackBack URL for this entry:' => 'このエントリーのトラックバックURL: ',
	'TrackBacks' => 'トラックバック',
	'TrackBacks ([_1])' => 'トラックバック ([_1])',
	'TrackBacks where' => 'トラックバック‐検索条件: ',
	'TrackBacks.' => 'トラックバック',
	'Trackbacks: [_1]' => 'トラックバック: [_1]',
	'Tracked on' => 'トラックバック時刻: ',
	'Tracked on [_1]' => 'トラックバック時刻: [_1]',
	'Transfer weblog entries into Movable Type from other blogging tools or export your entries to create a backup or copy.' => 'エントリーをほかのブログ・ツールからMovable Typeへ読み込むか、Movable Typeのエントリーをバックアップするために書き出します。',
	'Trust' => '登録する',
	'Trust commenter' => '登録する',
	'Trust Commenter(s)' => '登録する',
	'Trust selected commenters' => '登録する',
	'Trust&nbsp;Commenter' => '登録する',
	'Trusted' => '登録済み',
	'trusted' => '登録済み',
	'Trusted commenters only' => 'このブログに登録されたコメント投稿者のみ',
	'Trusted status has been removed from the selected commenter(s).' => '選択したコメント投稿者は、まだ登録されていません。',
	'two months back' => '2か月前',
	'Two plugins are in conflict' => '2つのプラグインで矛盾が発生しています。',
	'two weeks back' => '2週間前',
	'unassigned' => '未設定',
	'unauthenticated' => '未認証',
	'unauthenticated' => '許可する',
	'Unban commenter' => '投稿を許可する',
	'Unban Commenter(s)' => '投稿を許可する',
	'Unban&nbsp;Commenter' => '投稿を許可する',
	'Uncheck All' => 'すべてを非選択',
	'undefined type: [_1]' => '未定義の種類です: [_1]',
	'Underline' => 'アンダーライン',
	'Unknown action [_1]' => '「[_1]」はできません。',
	'Unknown archive type [_1] in <MTArchiveList>' => '<MTArchiveList>タグの種類の指定に誤りがあります。',
	'Unknown MailTransfer method \'[_1]\'' => 'サポートしてないメール転送方式「[_1]」が設定されています',
	'Unknown object type [_1]' => 'このオブジェクト「[_1]」には対応していません',
	'Unlink of \'[_1]\' failed: [_2]' => '「[_1]」の削除に失敗しました: [_2]',
	'Unlock this entry\'s output filename for editing' => 'このエントリーの出力ファイル名を編集するため、ロック解除します。',
	'Unnamed Junk Filter' => '迷惑コメント/トラックバック・フィルターがありません',
	'Unpublish Comment(s)' => 'コメントを未公開にする',
	'Unpublish Entries' => '未公開 (下書き) にする',
	'Unpublish TrackBack(s)' => 'トラックバックを未公開にする',
	'unpublished' => '未公開',
	'Unpublished' => '未公開 (下書き)',
	'Unpublished comments are held for moderation.' => '未公開のコメントは、事前確認待ちのものです。',
	'Unspecified archive template' => 'アーカイブ・テンプレートが指定されていません。',
	'Untrust' => '登録を解除する',
	'Untrust commenter' => '登録を解除する',
	'Untrust Commenter(s)' => '登録を解除する',
	'Untrust&nbsp;Commenter' => '登録を解除する',
	'untrusted' => '未登録',
	'Update failed on SQL error [_1]' => 'アップデート中にSQLエラーが発生しました: [_1]',
	'Updating author API passwords...' => 'データベースをアップグレードします: APIパスワード',
	'Updating blog comment email requirements...' => 'データベースをアップグレードします: コメント投稿者のメールアドレス関連',
	'Updating blog old archive link status...' => 'データベースをアップグレードします: アーカイブ・リンク',
	'Updating category placements...' => 'データベースをアップグレードします: カテゴリー関連の設定',
	'Updating comment status flags...' => 'データベースをアップグレードします: コメントの状態フラグ',
	'Updating commenter records...' => 'データベースをアップグレードします: コメント投稿者に関するレコード',
	'Updating entry week numbers...' => 'データベースをアップグレードします: 週番号',
	'Upgrade complete!' => 'アップグレードが完了しました。',
	'Upgrade complete.' => 'アップグレードが完了しました。',
	'Upgrading database from version [_1].' => 'バージョン: [_1]のデータベースからアップグレードします。',
	'Upgrading database...' => 'データベースをアップグレード中...',
	'Upgrading table for [_1]' => 'データベースをアップグレードします: [_1]',
	'Upload' => 'アップロード',
	'Upload Another' => '他の画像をアップロードする',
	'Upload File' => 'ファイルのアップロード',
	'Upload Into:' => 'アップロード先: ',
	'Uploaded Image Popup Template' => '画像のポップアップ・ウィンドウ',
	'URL' => 'URL',
	'URL (Optional):' => 'URL (オプション): ',
	'URL:' => 'URL: ',
	'Use defaults' => '標準の設定',
	'Use my settings' => 'カスタム設定',
	'Use this page to edit the attributes of the category [_1]. You can set a description for your category to be used in your public pages, as well as configuring the TrackBack options for this category.' => 'サイトに掲載するカテゴリーの説明や、このカテゴリーへのトラックバックの設定ができます。',
	'User [_1] upgraded database to version [_2]' => '[_1]がデータベースをアップグレードしました (バージョン: [_2])',
	'User \'[_1]\' (user #[_2]) added entry #[_3]' => '[_1] (ID: [_2]) が投稿しました (エントリーID: [_3])',
	'User \'[_1]\' (user #[_2]) logged in successfully' => '[_1] (ID: [_2]) がログインしました。',
	'User \'[_1]\' (user #[_2]) logged out' => '[_1] (ID: [_2]) がログアウトしました。',
	'User can create weblogs' => 'ブログの新規作成',
	'User can view activity log' => 'システム全体のログの参照',
	'Username' => 'ログイン名',
	'Username (*):' => 'ログイン名 (*): ',
	'Username:' => 'ログイン名: ',
	'UTC+0 (Universal Time Coordinated)' => 'UTC+0 (協定世界時)',
	'UTC+1 (Central European Time)' => 'UTC+1 (中央ヨーロッパ標準時)',
	'UTC+10 (East Australian Time)' => 'UTC+10 (オーストラリア東部標準時)',
	'UTC+11' => 'UTC+11 (ニューカレドニア)',
	'UTC+12 (International Date Line East)' => 'UTC+12 (ニュージーランド標準時)',
	'UTC+13 (New Zealand Daylight Savings Time)' => 'UTC+13 (トンガ)',
	'UTC+2 (Eastern Europe Time)' => 'UTC+2 (東ヨーロッパ標準時)',
	'UTC+3 (Baghdad Time/Moscow Time)' => 'UTC+3 (モスクワ標準時)',
	'UTC+3.5 (Iran)' => 'UTC+3.5 (イラン標準時)',
	'UTC+4 (Russian Federation Zone 3)' => 'UTC+4 (ロシア第3標準時)',
	'UTC+5 (Russian Federation Zone 4)' => 'UTC+5 (ロシア第4標準時)',
	'UTC+5.5 (Indian)' => 'UTC+5.5 (インド標準時)',
	'UTC+6 (Russian Federation Zone 5)' => 'UTC+6 (ロシア第5標準時)',
	'UTC+6.5 (North Sumatra)' => 'UTC+6.5 (ミャンマー標準時)',
	'UTC+7 (West Australian Time)' => 'UTC+7 (タイ標準時)',
	'UTC+8 (China Coast Time)' => 'UTC+8 (中国標準時)',
	'UTC+9 (Japan Time)' => 'UTC+9 (日本標準時)',
	'UTC+9.5 (Central Australian Time)' => 'UTC+9.5 (中央オーストラリア標準時)',
	'UTC-1 (West Africa Time)' => 'UTC-1 (ポルトガル標準時)',
	'UTC-10 (Aleutians-Hawaii Time)' => 'UTC-10 (ハワイ標準時)',
	'UTC-11 (Nome Time)' => 'UTC-11 (サモア標準時)',
	'UTC-2 (Azores Time)' => 'UTC-2 (南ジョージア島標準時)',
	'UTC-3 (Atlantic Time)' => 'UTC-3 (ブラジル標準時)',
	'UTC-3.5 (Newfoundland)' => 'UTC-3.5 (ニューファンドランド標準時)',
	'UTC-4 (Atlantic Time)' => 'UTC-4 (アメリカ大西洋標準時)',
	'UTC-5 (Eastern Time)' => 'UTC-5 (アメリカ東部標準時)',
	'UTC-6 (Central Time)' => 'UTC-6 (アメリカ中部標準時)',
	'UTC-7 (Mountain Time)' => 'UTC-7 (アメリカ山岳部標準時)',
	'UTC-8 (Pacific Time)' => 'UTC-8 (アメリカ太平洋標準時)',
	'UTC-9 (Alaskan Time)' => 'UTC-9 (アラスカ標準時)',
	'Utilities' => 'ユーティリティ',
	'Version' => 'バージョン',
	'View Activity Log' => 'ログの参照',
	'View Activity Log For This Weblog' => 'ログの参照',
	'View all commenters with this status' => '同じ状態のコメント投稿者をすべて表示',
	'View all Comments' => 'コメントの一覧',
	'View all comments by this commenter' => 'このコメント投稿者によるコメントをすべて表示',
	'View all comments from this IP address' => 'このIPアドレスからのコメントをすべて表示',
	'View all comments on this entry' => 'このエントリーへのコメントをすべて表示',
	'View all comments posted on this day' => 'この日に受け付けたコメントをすべて表示',
	'View all comments with this email address' => 'このメールアドレスからのコメントをすべて表示',
	'View all comments with this name' => 'このコメント投稿者によるコメントをすべて表示',
	'View all comments with this status' => '同じ状態のコメントをすべて表示',
	'View all comments with this URL' => 'このURLからのコメントをすべて表示',
	'View all comments with this URL address' => 'このURLからのコメントをすべて表示',
	'View all Entries' => 'エントリーの一覧',
	'View all TrackBacks' => 'トラックバックの一覧',
	'View all TrackBacks from this IP address' => 'このIPアドレスからのトラックバックをすべて表示',
	'View all TrackBacks on this category' => 'このカテゴリーへのトラックバックをすべて表示',
	'View all TrackBacks on this entry' => 'このエントリーへのトラックバックをすべて表示',
	'View all TrackBacks posted on this day' => 'この日に受け付けたトラックバックをすべて表示',
	'View all TrackBacks with this status' => '同じ状態のトラックバックをすべて表示',
	'View Entry' => 'エントリーを確認',
	'View image' => '画像の確認',
	'View Previously Sent TrackBacks' => '以前に送ったトラックバックを確認',
	'View Site' => 'サイトを確認',
	'View the [_1] for this TrackBack' => 'トラックバックの対象を表示',
	'View the inbound TrackBacks on this category.' => 'このカテゴリーのエントリーに対するトラックバックを表示する。',
	'View this comment:' => 'コメントを確認:  ',
	'View this commenter\'s profile' => 'コメント投稿者のプロフィールを表示',
	'View this page.' => 'このページを確認',
	'View this TrackBack:' => 'トラックバックを確認: ',
	'View your site' => 'サイトを確認',
	'View your site.' => 'サイトを確認',
	'View:' => '表示形式: ',
	'Warning' => '警告',
	'Warning: Changing this entry\'s basename may break inbound links.' => '警告: このエントリーのファイル名を変更すると、このページに対して張られたリンクが切断する可能性があります。',
	'Warning: If you set the basename manually, it may conflict with another entry.' => '警告: エントリーのファイル名を手動で指定した場合、別のエントリーと同じファイル名にならないように注意してください。',
	'Web server:' => 'ウェブ・サーバー: ',
	'Weblog' => 'ブログ',
	'weblog' => 'ブログ',
	'Weblog \'[_1]\' created by \'[_2]\' (user #[_3])' => '[_2] (ID: [_3]) がブログを新規作成しました: [_1]',
	'Weblog \'[_1]\' deleted by \'[_2]\' (user #[_3])' => '[_2] (ID: [_3]) がブログを削除しました: [_1]',
	'Weblog Associations' => '関連づけるブログ',
	'Weblog Name' => 'ブログ名',
	'Weblog Name:' => 'ブログ名: ',
	'Weblog Settings' => 'ブログの設定',
	'Weblog:' => 'ブログ: ',
	'Weblogs' => 'ブログ',
	'weblogs' => 'ブログ',
	'Weblogs:' => 'ブログ: ',
	'Website URL:' => 'ウェブサイトURL: ',
	'Welcome' => '現在のログイン名: ',
	'Welcome to [_1].' => 'スタート・ページ',
	'Welcome to Movable Type!' => 'Movable Typeへようこそ',
	'What is this?' => 'フィードとは',
	'What\'s been happening.' => 'すべてのログを確認できます。',
	'What\'s installed, access to more.' => 'インストールしているプラグインの一覧です。',
	'When an item has been marked as junk for this many days, it is automatically deleted.' => '指定した日数の後に、迷惑コメント/トラックバックと判断したものを削除します。',
	'When linking to an archived entry&#8212;for a permalink, for example&#8212;you must link to a particular archive type, even if you have chosen multiple archive types.' => 'パーマリンクに利用するアーカイブの種類を選んでください。複数作成していたとしても、特定のアーカイブを選ぶ必要があります。',
	'When this weblog is updated, Movable Type will automatically notify the selected sites.' => 'ブログが更新されたときに、指定したサイトに自動的に通知します。',
	'Width:' => '幅: ',
	'Wiki' => 'WiKi',
	'Withheld' => '未公開',
	'Would you like this file to be a:' => 'ファイルの表示方法を選んでください: ',
	'Writing to \'[_1]\' failed: [_2]' => '「[_1]」への書き込みに失敗しました: [_2]',
	'XML::Atom is required in order to use the Atom API.' => '「XML::Atom」は、Atom API を利用するときに必要です。',
	'Yes' => 'はい',
	'You are currently performing a search. Please wait until your search is completed.' => '現在検索中です。検索が終わるまでお待ちください。',
	'You are not allowed to edit the permissions of this author.' => '投稿者の権限を変更できません。',
	'You are not allowed to post comments.' => 'IPアドレス制限のため、コメント投稿が許されていません。',
	'You are not allowed to send TrackBack pings.' => 'トラックバックの送信が許可されていません。',
	'You are not authorized to log in to this blog.' => 'このブログにログインする権限がありません。',
	'You are not signed in. You need to be registered to comment on this site.' => 'サインインしていません。このサイトにコメントをする前に登録してください。',
	'You are pinging trackbacks too quickly. Please try again later.' => 'トラックバックの送信頻度が高すぎます。しばらくして、もう一度試してください。',
	'You can post to and manage your weblog by selecting an option from the menu located to the left of this message.' => '左側のメニューからブログに投稿したり、管理できます。',
	'You can send a notification message to your group of readers. Just enter the email message that you would like to insert below the weblog entry\'s link. You have the option of including the excerpt indicated above or the entry in its entirety.' => '読者にお知らせを送ることができます。エントリーへのリンクの下に添えるメールの文章を入力してください。概要やエントリーの本文を送るように設定することもできます。',
	'You can\'t delete that category because it has sub-categories. Move or delete the sub-categories first if you want to delete this one.' => 'そのカテゴリーを削除するには、まず、付属しているサブカテゴリーを移動するか、削除してください。',
	'You can\'t use both AND and OR in the same expression ([_1]).' => 'ANDとORは同時に利用できません。',
	'You cannot modify your own permissions.' => '現在の権限を変更できません。',
	'You cannot use a [_1] extension for a linked file.' => 'リンクされたファイルに拡張子[_1]は使えません。',
	'You did not choose a file to upload.' => 'アップロードするファイルが選択されていません。',
	'You did not enter an IP address to ban.' => '禁止IPアドレスの編集はできません。',
	'You did not select a timezone.' => '時間帯を選んでください。',
	'You did not set your Local Archive Path' => 'ローカル・アーカイブパスを設定してください',
	'You did not set your Local Site Path' => 'ローカル・サイトパスを設定してください',
	'You did not specify a weblog name.' => 'ブログの名称を設定してください。',
	'You do not have a valid path to sendmail on your machine. Perhaps you should try using SMTP?' => 'sendmailへのパスがありません。環境設定ファイルでSMTP経由の設定をしてください。',
	'You do not have a valid path to the NetPBM tools on your machine.' => 'あなたのマシンには、「NetPBM」ツールへのパスがありません。',
	'You do not have entry creation permission for any weblogs on this installation. Please contact your system administrator for access.' => 'ブログへの投稿に関する権限がありません。システム管理者に相談してください。',
	'You do not have export permissions' => '書き出しに関する権限がありません。',
	'You do not have import permissions' => '読み込みに関する権限がありません。',
	'You do not have permission to configure the blog' => 'ブログの設定に関する権限がありません。',
	'You do not have permission to create authors' => '投稿者を作成する権限がありません。',
	'You don\'t have permission to approve this comment.' => 'コメントを承認する権限がありません。',
	'You don\'t have permission to approve this TrackBack.' => 'トラックバックを承認する権限がありません。',
	'You have [quant,_1,user,users,no users] in your notification list.' => '[quant,_1,名が登録されています,名が登録されています,誰も登録されていません]。',
	'You have added [_1] to your list of banned IP addresses.' => '[_1]」禁止IPアドレスリストに追加しました。',
	'You have added [_1] to your notification list.' => '[_1]を通知リストに追加しました。',
	'You have banned [quant,_1,address,addresses].' => '[quant,_1,アドレス,アドレス]を禁止しました。',
	'You have successfully added a new archive-template association.' => 'アーカイブとテンプレートの関連づけが追加されました。',
	'You have successfully deleted the authors from the Movable Type system.' => '投稿者をMovable Typeのシステムから削除しました。',
	'You have successfully deleted the blogs from the Movable Type system.' => 'ブログをシステムから削除しました。',
	'You have successfully deleted the checked comment(s).' => 'チェックしたコメントは削除しました。',
	'You have successfully deleted the checked template(s).' => 'チェックしたテンプレートを削除しました。',
	'You have successfully deleted the checked TrackBack(s).' => 'このカテゴリーから、選択したトラックバックを削除しました。',
	'You have successfully deleted the selected categories.' => '選択したカテゴリーを削除しました。',
	'You have successfully deleted the selected IP addresses from the list.' => '選択したIPアドレスを禁止IPアドレスリストから削除しました。',
	'You have successfully deleted the selected notifications from your notification list.' => '選んだ通知先を一覧から削除しました。',
	'You may need to update your \'Master Archive Index\' template to account for your new archive configuration.' => 'アーカイブの設定を有効にするために、アーカイブページを更新する必要があります。',
	'You may need to update your templates to account for your new archive configuration.' => 'アーカイブの設定を有効にするために、テンプレートを更新する必要があります。',
	'You must choose a weblog in which to post the new entry.' => 'どのブログに投稿するのかを選択してください。',
	'You must define a Comment Error template.' => 'コメント・エラーのテンプレートを設定してください。',
	'You must define a Comment Listing template in order to display dynamic comments.' => 'コメントをダイナミックに表示するためには、コメントの一覧のテンプレートを設定してください。',
	'You must define a Comment Pending template.' => 'コメント・保留のテンプレートを設定してください。',
	'You must define a Comment Preview template.' => 'コメント・プレビューのテンプレートを設定してください。',
	'You must define a Ping template in order to display pings.' => 'トラックバックを表示するには、トラックバックの一覧のテンプレートを設定してください。',
	'You must define an Individual template in order to display dynamic comments.' => 'コメントをダイナミックに表示するためには、エントリー・アーカイブ・テンプレートを設定してください。',
	'You must select one or more item to replace.' => '置換対象を1つ以上選択してください。',
	'You must set your Local Site Path.' => 'サイト・パスが空欄、もしくは内容に誤りがあります。設定を確認してください。',
	'You must set your Site URL.' => 'サイトURLが空欄、もしくは内容に誤りがあります。設定を確認してください。',
	'You need a Google API key to use [_1]' => '「[_1]」を使うにはGoogle APIキーが必要です。',
	'You need to provide a password if you are going to create new authors for each author listed in your blog.' => 'ファイルを読み込んだ際に、新しく投稿者を登録する場合は、初期パスワードの入力が必要です。',
	'You used [_1] without a query.' => '「[_1]」を利用するときは クエリーを指定してください。',
	'You used <$MTCategoryDescription$> outside of the proper context.' => '<$MTCategoryDescription$>タグを適切な場所で使っていません。',
	'You used <$MTEntryFlag$> without a flag.' => '<$MTEntryFlag$>タグにはフラグが必要です。',
	'You used a [_1] tag without any arguments.' => '[_1]タグには引数が必要です。',
	'You used a non-existent property from the result structure.' => '存在していない項目を指定しています。',
	'You used an [_1] tag for linking into \'[_2]\' archives, but that archive type is not published.' => '[_1]タグを使って、[_2]アーカイブにリンクしようとしましたが、そのアーカイブ・タイプは公開されていません。',
	'You used an [_1] tag outside of a Daily, Weekly, or Monthly context.' => '[_1]タグは日付ベースのアーカイブでのみ使えます。',
	'You used an [_1] tag outside of the proper context.' => '[_1]タグが適切なコンテキスト外で使われました。',
	'You used an [_1] tag without a date context set up.' => '[_1]タグには日付コンテキスト設定が必要です。',
	'You used an [_1] without a date context set up.' => '[_1]には日付コンテキスト設定が必要です。',
	'You used an \'[_1]\' tag outside of the context of a comment; perhaps you mistakenly placed it outside of an \'MTComments\' container?' => 'コメント以外の場所で[_1]タグを利用できません。<MTComment>コンテナの外側で使っているのかもしれません',
	'You used an \'[_1]\' tag outside of the context of a ping; perhaps you mistakenly placed it outside of an \'MTPings\' container?' => '[_1]タグを適切な場所で使っていません。<MTPings>コンテナの外で使っていませんか?',
	'You used an \'[_1]\' tag outside of the context of an entry; perhaps you mistakenly placed it outside of an \'MTEntries\' container?' => '[_1]タグが、エントリーのコンテキスト外で使われた可能性があります。<MTEntries>コンテナの外に誤って記述していませんか?',
	'You will be assigned the author of all imported entries.  If you wish the original authors to keep ownership, you must contact your MT system administrator to perform the import so that new authors can be created if necessary.' => '現在の投稿者の情報で読み込みます。元の投稿者名で読み込む場合は、システム管理者に相談し、必要であれば該当する投稿者を事前に作成してから読み込んでください。',
	'You\'re ready to go!' => '準備が整いました。',
	'Your [_1] has been rebuilt.' => '[_1]を再構築しました。',
	'Your [_1] pages have been rebuilt.' => '[_1]を再構築しました。',
	'Your Account' => 'あなたのアカウント',
	'Your API Password is currently' => '現在のAPI用パスワード: ',
	'Your blog preferences have been saved.' => 'ブログの設定を保存しました。',
	'Your category changes and additions have been made.' => 'カテゴリーの変更と追加を行いました。',
	'Your category changes have been made.' => 'カテゴリーの変更を行いました。',
	'Your changes have been saved.' => '変更を保存しました。',
	'Your changes to [_1]\'s permissions have been saved.' => '[_1]の権限の変更を保存しました。',
	'Your changes to the comment have been saved.' => 'コメントの変更を保存しました。',
	'Your comment has been received and held for approval by the blog owner.' => 'コメントを受け付けました。受け付けたコメントは、ブログの管理者の承認のため保留されています。',
	'Your comment submission failed for the following reasons:' => '次のエラーでコメントを投稿できませんでした: ',
	'Your customization preferences have been saved, and are visible in the form below.' => 'カスタマイズの設定を変更しました。下のフォームを確認してください。',
	'Your database directory (\'[_1]\') is not writable.' => 'データベース・ディレクトリー[_1]は、書き込みできません。',
	'Your database file (\'[_1]\') is not writable.' => 'データベース・ファイル[_1]は、書き込みできません。',
	'Your database is already current.' => 'データベースは最新の設定です。',
	'Your DataSource directory (\'[_1]\') does not exist.' => 'データベースを格納するディレクトリー[_1]がありません。',
	'Your DataSource directory (\'[_1]\') is not writable.' => 'データベースを格納するディレクトリー[_1]が書き込み可能ではありません。',
	'Your entry has been deleted from the database.' => 'エントリーをデータベースから削除しました。',
	'Your entry has been saved. You can now make any changes to the entry itself, edit the authored-on date, edit comments, or send a notification.' => 'エントリーを保存しました。エントリーの変更、作成日、コメントの編集、通知の送信ができます。',
	'Your entry screen preferences have been saved.' => 'エントリーの入力画面の設定を保存しました。',
	'Your feedback preferences have been saved.' => '設定を保存しました。',
	'Your file has been uploaded. Size: [quant,_1,byte].' => 'ファイルをアップロードしました。(サイズ: [quant,_1,バイト,バイト])',
	'Your login session has expired.' => 'ログアウトしました。',
	'Your Movable Type session has ended. If you wish to log in again, you can do so below.' => 'ログアウトしました。ログインする場合は、この画面からログインしてください。',
	'Your Movable Type session has ended. Please login again to continue this action.' => 'ログアウトしました。ログインする場合は、この画面からログインしてください。',
	'Your new entry has been saved to [_1]' => '[_1]に新しいエントリーを保存しました',
	'Your notification has been sent.' => 'お知らせメールを送信しました。',
	'Your password has been changed, and the new password has been sent to your email address ([_1]).' => 'パスワードを変更しました。新しいパスワードは、「[_1]」宛てにメールで送りました。',
	'Your plugin settings have been reset.' => 'プラグインの設定を初期化しました。',
	'Your plugin settings have been saved.' => 'プラグインの設定を保存しました。',
	'Your plugins have been reconfigured.' => 'プラグインを再設定しました。',
	'Your plugins have been reconfigured. Since you\'re running mod_perl, you will need to restart your web server for these changes to take effect.' => 'プラグインを再設定しました。mod_perl環境下でお使いの場合は、ウェブサーバーを再起動（リスタート）してください。',
	'Your profile has been updated.' => 'プロフィールを更新しました。',
	'Your server does not have [_1] installed, or [_1] requires another module that is not installed.' => 'サーバーに、「[_1]」がインストールされていないか、「[_1]」に必要なモジュールがインストールされていません',
	'Your server has [_1] installed (version [_2]).' => 'サーバーには、[_1]がインストールされています。(バージョン: [_2])',
	'Your server has all of the required modules installed; you do not need to perform any additional module installations. Continue with the installation instructions.' => 'サーバーには必要なモジュールがすべて揃っています。追加のモジュールのインストールは必要ありません。インストールの説明に従って、次の手順に進んでください。',
	'Your settings have been saved.' => '設定を保存しました。',
	'Your template changes have been saved.' => '変更したテンプレートを保存しました。',
	'Your weblog configuration has been saved.' => 'ブログの設定を保存しました。',
	'Your weblog does not have an explicit Creative Commons license.' => 'クリエイティブ・コモンズ・ライセンスを設定していません。',
	'Your weblog has not been configured with a site path and URL. You cannot publish entries until these are defined.' => 'サイト・パスとURLを設定しないと、エントリーを公開できません。',
	'Your weblog is currently licensed under:' => '現在のライセンス: ',
	'Your weblog\'s archive configuration has been saved.' => 'アーカイブの設定を保存しました。',
	'\'Are you sure you want to delete the \' + count + \' selected \' + plural + \'?\'' => 'count + \'件の\' + plural +\'を削除していいですか?\'',
	'\'Are you sure you want to delete this \' + singular + \'?\'' => '\'この\' + singular +\'を削除していいですか?\'',
	'\'You did not select any \' + plural + \' \' + phrase + \'.\'' => 'phrase + \'する\' + plural + \'を選択してください。\'',
	'\'You did not select any \' + plural + \' to delete.\'' => '\'削除する\' + plural + \'を選択してください。\'',
	'to mark as junk' => '迷惑コメント/トラックバックとして設定',
	'to remove "junk" status' => '迷惑コメント/トラックバックから解除',
	'You must select an action.' => 'プルダウン・メニューから選択してください。',
	'Adds a \'nofollow\' relationship to comment and TrackBack hyperlinks to reduce spam.' => '迷惑コメント/スパム対策の1つとして、コメントやトラックバックのハイパーリンク (アンカータグ) に、rel=&quot;nofollow&quot;を追加します。',
	'Don\'t add nofollow to links in comments by authenticated commenters' => '認証済みコメント投稿者からのコメントには追加しない',
	'Restrict:' => '追加の制限: ',
	'Backup and refresh existing templates to Movable Type\'s default templates.' => '既存のテンプレート・デザインをバックアップした後に、標準のテンプレート・デザインに更新します。',
	'Backup and Refresh Templates' => 'テンプレートのバックアップ・更新',
	'Created template \'[_1]\'.' => 'テンプレートを作成しました: [_1]',
	'Error creating new template: ' => 'テンプレート作成時にエラーが発生しました: ',
	'Error loading default templates.' => '標準テンプレート・デザインの読み込み中にエラーが発生しました。',
	'Insufficient permissions for modifying templates for this weblog.' => 'テンプレートを更新する権限がありません。',
	'Insufficient permissions to modify templates for weblog \'[_1]\'' => 'テンプレートを更新する権限がありません: [_1]',
	'No templates were selected to process.' => '更新するテンプレートが選択されていません。',
	'Processing templates for weblog \'[_1]\'' => '次のブログのテンプレートを更新します: [_1]',
	'Refreshing (with <a href=\"?__mode=view&amp;blog_id=[_1]&amp;_type=template&amp;id=[_2]\">backup</a>) template \'[_3]\'.' => 'テンプレートを更新します: [_3] (<a href=\"?__mode=view&amp;blog_id=[_1]&amp;_type=template&amp;id=[_2]\">バックアップ</a>)',
	'Refreshing template \'[_1]\'.' => 'テンプレート更新中: [_1]',
	'Return' => '戻る',
	'Skipping template \'[_1]\' since it appears to be a custom template.' => 'カスタム・テンプレートのため更新しません: [_1]',
	'[_1] found on service [_2]' => '[_1]が見つかりました: [_2]',
	'Adjust scoring' => '基準値の変更',
	'Advanced TrackBack Lookups:' => 'トラックバックのチェック: ',
	'Credit feedback rating when &quot;URL&quot; element of feedback has been published before' => '既に公開したURLが含まれているコメント/トラックバックを「問題のないもの」として処理します',
	'Credit feedback rating when no hyperlinks are present' => 'リンクが含まれていないコメント/トラックバックを「問題のないもの」として処理します',
	'Credit feedback rating when previously published comments are found matching on the &quot;Email&quot; address' => '既に公開したコメントのメールアドレスが合致した場合に「問題のないもの」として処理します',
	'domain \'[_1]\' found on service [_2]' => 'ドメイン[_1]が見つかりました: [_2]',
	'Domain Blacklist Services:' => 'ブラックリスト: ',
	'Domain IP does not match ping IP for source URL [_1]; domain IP: [_2]; ping IP: [_3]' => 'ドメインのIPアドレス「[_2]」と送信元「[_1]」のIPアドレス「[_3]」が合致しません',
	'Domain Name Lookups:' => 'ドメインのチェック: ',
	'Email Memory:' => 'メール・メモリー: ',
	'E-mail was previously published (comment id [_1]).' => '既に公開されたメールアドレスです: [_1]',
	'Failed to resolve IP address for source URL [_1]' => 'URLからIPアドレスを解決できませんでした: [_1]',
	'Incomming feedback can be monitored for specific keywords, domain names, and patterns. Matches can be held for moderation or scored as junk. Additionally, junk scores for these matches can be customized.' => '受け付けたすべてのコメント/トラックバックの内容をチェックします。受け付けた内容に、指定したキーワードが含まれている場合、「未公開」もしくは「迷惑コメント/トラックバック」として処理します。',
	'IP Address Lookups:' => 'アドレスのチェック: ',
	'IP Blacklist Services:' => 'ブラックリスト: ',
	'Junk feedback containing blacklisted domains' => 'ブラックリストに含まれるドメインからの受信を「迷惑コメント/トラックバック」にする',
	'Junk feedback from blacklisted IP addresses' => 'ブラックリストに含まれるIPアドレスからの受信を「迷惑コメント/トラックバック」にする',
	'Junk TrackBacks from suspicious sources' => '疑わしいサイトからのトラックバックを「迷惑トラックバック」にする',
	'Junk when more than' => '超えた場合に「迷惑コメント/トラックバック」にする: ',
	'Keywords to Junk:' => '迷惑キーワード: ',
	'Keywords to Moderate:' => '未公開キーワード:',
	'Link filters monitor the number of hyperlinks in incoming feedback. Feedback with many links can be held for moderation or scored as junk. Conversely, feedback that does not contain links or only refers to previously published URLs can be positively rated. (Only enable this option if you are sure your site is already spam-free.)' => '受け付けたすべてのコメント/トラックバックの内容をチェックします。受け付けた内容に、指定した数を超えるリンクが含まれている場合、「未公開」もしくは「迷惑コメント/トラックバック」として処理します。逆に、リンクが含まれていないもの、既に公開しているものを「問題のないもの」として設定することもできます。',
	'Link Limits:' => 'リンク数: ',
	'Link Memory:' => 'リンク・メモリー: ',
	'Link was previously published (comment id [_1]).' => '既に公開されたリンクです: [_1]',
	'Link was previously published (TrackBack id [_1]).' => '既に公開されたリンクです: [_1]',
	'link(s) are given' => '',
	'Lookup Whitelist:' => 'ホワイトリスト: ',
	'Lookups monitor the source IP addresses and hyperlinks of all incoming feedback. If a comment or TrackBack comes from a blacklisted IP address or contains a blacklisted domain, it can be held for moderation or scored as junk and placed into the blog\'s Junk folder. Additionally, advanced lookups on TrackBack source data can be performed.' => '受け付けたすべてのコメント/トラックバックのIPアドレス/ドメインをチェックします。送信元のIPアドレス/ドメインがブラックリストに含まれている場合、「未公開」もしくは「迷惑コメント/トラックバック」として処理します。',
	'Moderate feedback containing blacklisted domains' => 'ブラックリストに含まれるドメインからの受信を「未公開」にする',
	'Moderate feedback from blacklisted IP addresses' => 'ブラックリストに含まれるIPアドレスからの受信を「未公開」にする',
	'Moderate TrackBacks from suspicious sources' => '疑わしいサイトからのトラックバックを「未公開」にする',
	'Moderate when more than' => '超えた場合に「未公開」にする: ',
	'Moderating for Word Filter match on \'[_1]\': \'[_2]\'.' => 'Moderating for Word Filter match on \'[_1]\': \'[_2]\'.',
	'Moderating: Domain IP does not match ping IP for source URL [_1]; domain IP: [_2]; ping IP: [_3]' => 'ドメインのIPアドレス「[_2]」と送信元「[_1]」のIPアドレス「[_3]」が合致しないため、「未公開」にします。',
	'No links are present in feedback' => 'リンクがありません。',
	'Number of links exceed junk limit ([_1])' => 'リンク数が設定値 (迷惑コメント/トラックバック) を超えました: [_1]',
	'Number of links exceed moderation limit ([_1])' => 'リンク数が設定値 (未公開) を超えました: [_1]',
	'Only applied when no other links are present in message of feedback.' => 'メールやコメント/トラックバック内にリンクが含まれていない場合のみ適用されます。',
	'Score weight:' => '判断基準値: ',
	'SpamLookup module for junking and moderating feedback based on link filters.' => 'リンク・フィルター機能により、迷惑コメント/トラックバックをチェックします。',
	'SpamLookup module for moderating and junking feedback using keyword filters.' => '指定されたキーワードにより、迷惑コメント/トラックバックをチェックします。',
	'SpamLookup module for using blacklist lookup services to filter feedback.' => 'ブラックリストにより、迷惑コメント/トラックバックをチェックします。',
	'To prevent lookups for some IP addresses or domains, list them below. Place each entry on a line by itself.' => 'ブラックリストのチェックから除外するIPアドレス/ドメイン (ホワイトリスト) を登録できます。複数登録する場合は、改行してください。',
	'Word Filter match on \'[_1]\': \'[_2]\'.' => 'キーワードが合致しました: [_2] ([_1])',

);

1;
